#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gtk
import hildon
import os
import sys

from MappingSettings import *

userConfigPath = os.getenv("HOME") + "/.zeecontrol"
sys.path.append(userConfigPath)
import UserMappings

def set_alt_button(selector, col):
  print "Setting alt key to: " + selector.get_current_text()
  UserMappings.altButton = selector.get_current_text()
 
def set_use_alt(button):
  print "Setting useAlt = " + str(button.get_active())
  UserMappings.useAlt = button.get_active()

class ZeecontrolMenu():
  def __init__(self, app):
    self.app = app
    self.menu = hildon.AppMenu()
    
    title = "Edit Mapping"
    self.addButton(title, open_mapping_settings, self.app)

    title = "Edit Alternate Mapping"
    self.addButton(title, open_alt_mapping_settings, self.app)

    self.addToggleButton("Use Alternate Mapping", set_use_alt)

    self.addSelector("Set Alt. Toggle Button", set_alt_button, ['A', 'B', 'C', 'D'])

    self.menu.show_all()
    self.app.getWindow().set_app_menu(self.menu)

  def addButton(self, title, callback, app=None):
    button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
    button.set_label(title)
    if app :
      button.connect("clicked", callback, title, app)
    else:
      button.connect("clicked", callback, title)

    self.menu.append(button)

  def addSelector(self, title, callback, list):
    selector = hildon.TouchSelector( text = True )
    selector.connect("changed", callback)

    for i in list:
      selector.append_text(i)

    button = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
    button.set_title(title)
    button.set_selector(selector)
    button.set_active(list.index(UserMappings.altButton))

    self.menu.append(button)

  def addToggleButton(self, title, callback):
    button = gtk.ToggleButton(title)
    button.set_active(UserMappings.useAlt)
    button.connect("toggled", callback)
    self.menu.append(button)

