#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import hildon
import gtk
import shutil

from ZeeButton import ZeeButton
from ZeecontrolMenu import ZeecontrolMenu
from Zeemote import ZeeDiscover

class ZeecontrolGUI(hildon.Program):
  def __init__(self):
    hildon.Program.__init__(self)
    self.window = hildon.StackableWindow()
    self.window.connect("destroy", gtk.main_quit)  
    self.add_window(self.window)

    vbox = gtk.VBox(False, 0)
    self.window.add(vbox)
    vbox.show()
        
    self.image = gtk.Image()
    self.image.show()
        
    self.label = gtk.Label("")
    vbox.pack_start(self.label, True, True, 0)        
    self.label.show()   

    zeeButtonBox = gtk.HBox(False, 0)
    vbox.pack_start(zeeButtonBox)
    zeeButtonBox.show()

    zeeDiscover = ZeeDiscover()
    deviceCount = zeeDiscover.getZeemoteCount()
    print "Found %d Zeemote(s)." % deviceCount
    for i in range (1, deviceCount+1):
      zeeButton = ZeeButton(self, zeeButtonBox, i)
      if i == 1:
        self.selectedZeeButton = zeeButton

    buttonBox1 = gtk.HBox(False, 0)        
    vbox.pack_start(buttonBox1)
    buttonBox1.show()

    buttonBox2 = gtk.HBox(False, 0)        
    vbox.pack_start(buttonBox2)
    buttonBox2.show()

    for i in ['A', 'B', 'C', 'D']:
      button = gtk.Button(i)
      button.connect("clicked", self.setMapping, i)
      buttonBox1.pack_start(button, True, True, 0)
      button.show()

    for i in ['E', 'F', 'G', 'H']:
      button = gtk.Button(i)
      button.connect("clicked", self.setMapping, i)
      buttonBox2.pack_start(button, True, True, 0)
      button.show()

    self.menu = ZeecontrolMenu(self)
        
    stack = hildon.WindowStack.get_default()
    stack.push(self.window)
    self.window.show_all()

    while gtk.events_pending():
      gtk.main_iteration()                
 
  def finishShutdown(self):
    self.selectedZeeButton.safeMappings()

  def getWindow(self):
    return self.window

  def getZeeButton(self):
    return self.selectedZeeButton

  def setMapping(self, widget, newMapping=None):
    self.selectedZeeButton.setMapping(newMapping)

  def setSelectedZeeButton(self, zeeButton):
    self.selectedZeeButton = zeeButton

  def signalUser(self, usertext):
    self.label.set_text(usertext)
    while gtk.events_pending():
      gtk.main_iteration()     
    print usertext  
        
