#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Specify whether to us an alternate function when the "hot key"
# given by altButton is pressed.
useAlt = False
altButton = "B"

# Define default mappings for Zeemotes.
defaultMappings={
    1: "A",
    2: "B",
    3: "C",
    4: "D"
    }

# Some useful key names:
#   Up, Down, Left, Right  (D-pad)
#   Return (this is also the central button of the D-pad)
#   Escape
#   space
#   Shift_L
#   F6  (Fullscreen key)
#   F7  (Zoom/volume -)
#   F8  (Zoom/volume +) 
#   F4  (Menu key)
mappingA={
    'A': ["a x"],    
    'B': ["a d"],  
    'C': ["a w"],       
    'D': ["a c"],   
    'GU': ["a Up"],
    'GD': ["a Down"],
    'GL': ["a Left"],
    'GR': ["a Right"]
    }

mappingB={
    'A': ["a x"],    
    'B': ["a d"],  
    'C': ["a w"],       
    'D': ["a c"],   
    'GU': ["a Up"],
    'GD': ["a Down"],
    'GL': ["a Left"],
    'GR': ["a Right"]
    }

mappingC={
    'A': ["a d"],    
    'B': ["a w"],  
    'C': ["a a"],       
    'D': ["a s"],   
    'GU': ["a Up"],
    'GD': ["a Down"],
    'GL': ["a Left"],
    'GR': ["a Right"]
    }

mappingD={
    'A': ["a d"],    
    'B': ["a w"],  
    'C': ["a a"],       
    'D': ["a s"],   
    'GU': ["a Up"],
    'GD': ["a Down"],
    'GL': ["a Left"],
    'GR': ["a Right"]
    }

mappingE={
    'A': ["a Shift_L"],    
    'B': ["a space"],  
    'C': ["a w"],       
    'D': ["a s"],   
    'GU': ["a Up"],
    'GD': ["a Down"],
    'GL': ["a Left"],
    'GR': ["a Right"]
    }

mappingF={
    'A': ["a d"],    
    'B': ["a w"],  
    'C': ["a a"],       
    'D': ["a s"],   
    'GU': ["a Up"],
    'GD': ["a Down"],
    'GL': ["a Left"],
    'GR': ["a Right"]
    }

mappingG={
    'A': ["a d"],    
    'B': ["a w"],  
    'C': ["a a"],       
    'D': ["a s"],   
    'GU': ["a Up"],
    'GD': ["a Down"],
    'GL': ["a Left"],
    'GR': ["a Right"]
    }

mappingH={
    'A': ["a d"],    
    'B': ["a w"],  
    'C': ["a a"],       
    'D': ["a s"],   
    'GU': ["a Up"],
    'GD': ["a Down"],
    'GL': ["a Left"],
    'GR': ["a Right"]
    }

altMappingA={
    'A': ["a d"],    
    'B': ["a w"],  
    'C': ["a Space"],       
    'D': ["k F6"],   
    'GU': ["a Up"],
    'GD': ["a Down"],
    'GL': ["a Left"],
    'GR': ["a Right"]
    }

altMappingB={
    'A': ["a d"],    
    'B': ["a w"],  
    'C': ["a Space"],       
    'D': ["k F6"],   
    'GU': ["a Up"],
    'GD': ["a Down"],
    'GL': ["a Left"],
    'GR': ["a Right"]
    }

altMappingC={
    'A': ["a d"],    
    'B': ["a w"],  
    'C': ["a Space"],       
    'D': ["k F6"],   
    'GU': ["a Up"],
    'GD': ["a Down"],
    'GL': ["a Left"],
    'GR': ["a Right"]
    }

altMappingD={
    'A': ["a d"],    
    'B': ["a w"],  
    'C': ["a Space"],       
    'D': ["k F6"],   
    'GU': ["a Up"],
    'GD': ["a Down"],
    'GL': ["a Left"],
    'GR': ["a Right"]
    }

altMappingE={
    'A': ["a d"],    
    'B': ["a w"],  
    'C': ["a Space"],       
    'D': ["k F6"],   
    'GU': ["a Up"],
    'GD': ["a Down"],
    'GL': ["a Left"],
    'GR': ["a Right"]
    }

altMappingF={
    'A': ["a d"],    
    'B': ["a w"],  
    'C': ["a Space"],       
    'D': ["k F6"],   
    'GU': ["a Up"],
    'GD': ["a Down"],
    'GL': ["a Left"],
    'GR': ["a Right"]
    }

altMappingG={
    'A': ["a d"],    
    'B': ["a w"],  
    'C': ["a Space"],       
    'D': ["k F6"],   
    'GU': ["a Up"],
    'GD': ["a Down"],
    'GL': ["a Left"],
    'GR': ["a Right"]
    }

altMappingH={
    'A': ["a d"],    
    'B': ["a w"],  
    'C': ["a Space"],       
    'D': ["k F6"],   
    'GU': ["a Up"],
    'GD': ["a Down"],
    'GL': ["a Left"],
    'GR': ["a Right"]
    }

