#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
import gtk
import os
import sys
from threading import Thread

from KeyMappings import *
from XControl import XControl
from Zeemote import ZeeDiscover, Zeemote, buttonmap

# If a user config directoryis present try to load mappings
# from there.
userConfigPath = os.getenv("HOME") + "/.zeecontrol"
if os.path.isdir(userConfigPath):
  sys.path.append(userConfigPath)
  from UserMappings import *

class ZeemoteEventThread(Thread):
  def __init__ (self, zeeBtn):
    Thread.__init__(self)
    self.setDaemon(True)
    self.zeeBtn = zeeBtn
    self.control = XControl()

    self.mapping = mappingA
    self.altMapping = altMappingA

    self.pressed={
      'A': [False],
      'B': [False],
      'C': [False],
      'D': [False],
      'GU': [False],
      'GD': [False],
      'GL': [False],
      'GR': [False]
      }

  def run(self):
    buttons='ABCD'
    xpon=False
    ypon=False
    xnon=False
    ynon=False
    TOLERANCE=18000

    discover = ZeeDiscover()
    self.zee = discover.getZeemote( (self.zeeBtn.getId() - 1) )
    state = self.zee.getState()

    self.zeeBtn.signalConnected()

    while state.isConnected() :
      self.zee.waitForData()
      state = self.zee.getState()

#      print "button mask %d" % state.getButtonMask()

      # Adjust sign and axis association here in order
      # to keep the code taken from wiicontrol below.
      gy=-state.getX()
      gx=-state.getY()

#      print str(gx)+ " " + str(gy)

      #X is positive
      if gx > TOLERANCE and not xpon:
        xpon = True
        self.control.executeScript(self.mapping["GU"])               
      if xpon and gx < TOLERANCE and gx > -TOLERANCE:
        xpon = False
        self.control.executeReleasedScript(self.mapping["GU"])
      #X is negative
      if gx < -TOLERANCE and not xnon:
        xnon = True
        self.control.executeScript(self.mapping["GD"])
      if xnon and gx < TOLERANCE and gx > -TOLERANCE:
        xnon = False
        self.control.executeReleasedScript(self.mapping["GD"])
             
      #Y is positive
      if gy > TOLERANCE and not ypon:
        ypon = True
        self.control.executeScript(self.mapping["GL"])
      if ypon and gy < TOLERANCE and gy > -TOLERANCE:
        ypon = False
        self.control.executeReleasedScript(self.mapping["GL"])
      #Y is negative
      if gy < -TOLERANCE and not ynon:
        ynon = True
        self.control.executeScript(self.mapping["GR"])
      if ynon and gy < TOLERANCE and gy > -TOLERANCE:
        ynon = False
        self.control.executeReleasedScript(self.mapping["GR"])

      buttonmask = state.getButtonMask()
      for bb in buttons:
        if (buttonmask & buttonmap[bb]):          
          if useAlt and buttonmap & buttonmap[altButton]:
            self.control.executeScript(self.altMapping[bb])
            self.pressed[bb]=True                      
          else:
            self.control.executeScript(self.mapping[bb])
            self.pressed[bb]=True
        elif (not (buttonmask & buttonmap[bb])):
          if self.pressed[bb]==True:
            self.pressed[bb]=False                          
            self.control.executeReleasedScript(self.mapping[bb])

      while gtk.events_pending():
      	gtk.main_iteration()                

    print "Leaving event thread..."

    for bb in buttons:
      if self.pressed[bb]==True:
        self.pressed[bb]=False                          
        self.control.executeReleasedScript(self.mapping[bb])

    gtk.main_quit()

  def setMapping(self, newMapping):
    self.mapping = newMapping

  def setAltMapping(self, newAltMapping):
    self.altMapping = newAltMapping

