#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gobject
import gtk
import os
import sys
from KeyMappings import *
from ZeemoteEventThread import ZeemoteEventThread

# If a user config directoryis present try to load mappings
# from there.
userConfigPath = os.getenv("HOME") + "/.zeecontrol"
if os.path.isdir(userConfigPath):
  sys.path.append(userConfigPath)
  from UserMappings import *

class ZeeButton():
  def __init__(self, gui, container, id):
    self.id = id
    self.gui = gui
    self.connected = False

    self.vbox = gtk.VBox(False, 0)
    container.add(self.vbox)
    self.vbox.show()

    self.label = gtk.Label("")
    self.eb = gtk.EventBox()
    self.eb.add(self.label)
    self.eb.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse('#880000'))
    self.vbox.add(self.eb)

    self.button = gtk.Button(str(id))
    self.button.connect("clicked", self.callback)
    self.vbox.pack_start(self.button, True, True, 0)
    self.button.show()

    if self.id == 1:
      self.connect()

  def connect(self):
    self.eb.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse('#000088'))
    self.gui.signalUser("Trying to connect Zeemote %d." % self.id)
    gobject.threads_init()
    self.eventThread = ZeemoteEventThread(self)
    self.eventThread.start()

  def signalConnected(self):
    self.eb.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse('#008800'))
    self.gui.signalUser("Zeemote %d connected. Have fun!" % self.id)
    self.setMapping(defaultMappings[self.id])
    self.connected = True

  def callback(self, widget):
    print "Callback %d" % self.id
    if not self.connected:
      self.connect()
    else:
      self.gui.setSelectedZeeButton(self)

  def setMapping(self, m):
    print "Setting mapping for Zeemote %d to %s." % (self.id, m)
    self.eventThread.setMapping(globals()["mapping"+m])
    self.eventThread.setAltMapping(globals()["altMapping"+m])
    self.label.set_text(m)

  def getId(self):
    return self.id



