# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import dbus

def getBTAdapter():
  bus = dbus.SystemBus()
  root = bus.get_object("org.bluez", "/")
  manager = dbus.Interface(root, "org.bluez.Manager")
  defaultAdapter = manager.DefaultAdapter()
  obj = bus.get_object("org.bluez", defaultAdapter)
  return dbus.Interface(obj, "org.bluez.Adapter")
 
def setBTState(state):
  adapter = getBTAdapter()
  adapter.SetProperty("Powered", state)

def getBTState():
  adapter = getBTAdapter()
  props = adapter.GetProperties()
  state = props["Powered"]
  return state

