# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import hildon
import gtk
from threading import Thread

from KeyMappings import mappingA, mappingB, mappingC, mappingD, altMappingA, altMappingB, altMappingC, altMappingD
from XControl import XControl
from Zeemote import ZeeDiscover, Zeemote, buttonmap

pressed={
    'A': [False],
    'B': [False],
    'C': [False],
    'D': [False],
    'GU': [False],
    'GD': [False],
    'GL': [False],
    'GR': [False]
    }

# Set defaults.
mapping = mappingA
altMapping = altMappingA
useAlt = False

class ZeecontrolGUI(hildon.Program):
  def __init__(self):
    hildon.Program.__init__(self)
    self.window = hildon.Window()
    self.window.connect("destroy", gtk.main_quit)  
    self.add_window(self.window)
        
    self.buttonA = gtk.Button("A")
    self.buttonA.connect("clicked", self.setA)
        
    self.buttonB = gtk.Button("B")
    self.buttonB.connect("clicked", self.setB)
        
    self.buttonC = gtk.Button("C")
    self.buttonC.connect("clicked", self.setC)
        
    self.buttonD = gtk.Button("D")
    self.buttonD.connect("clicked", self.setD)
        
    vbox = gtk.VBox(False, 0)
    self.window.add(vbox)
    vbox.show()
        
    hbox = gtk.HBox(False, 0)        
    hbox2 = gtk.HBox(False, 0)        
    hbox3 = gtk.HBox(False, 0)        
       
    self.image = gtk.Image()
    self.image.show()
        
    self.label = gtk.Label("Trying to connect to Zeemote...")
    vbox.pack_start(self.label, True, True, 0)
        
    self.label.show()   
    vbox.pack_start(hbox)
    hbox.show()
        
    hbox.pack_start(self.buttonA, True, True, 0)
    hbox.pack_start(self.buttonB, True, True, 0)
    hbox.pack_start(self.buttonC, True, True, 0)
    hbox.pack_start(self.buttonD, True, True, 0)
               
    self.buttonA.show()
    self.buttonB.show()
    self.buttonC.show()
    self.buttonD.show()
    self.window.show_all()
    while gtk.events_pending():
      gtk.main_iteration()                
    
  def setA(self, widget):
    print "setA"
    mapping = mappingA
    altMapping = altMappingA
        
  def setB(self, widget):
    print "setB"
    mapping = mappingB
    altMapping = altMappingB
        
  def setC(self, widget):
    print "setC"
    mapping = mappingC
    altMapping = altMappingC
        
  def setD(self, widget):
    print "setD"
    mapping = mappingD
    altMapping = altMappingD

  def signalUser(self, usertext):
    self.label.set_text(usertext)
    while gtk.events_pending():
      gtk.main_iteration()     
    print usertext  
        
class ZeemoteEventThread(Thread):
  def __init__ (self, gui):
    Thread.__init__(self)
    self.setDaemon(True)
    self.gui = gui
    self.control = XControl()

  def run(self):
    buttons='ABCD'
    xpon=False
    ypon=False
    xnon=False
    ynon=False
    TOLERANCE=18000

    discover = ZeeDiscover()
    zee = discover.getZeemote()
    state = zee.getState()

    self.gui.signalUser( 'Zeemote connected. Have fun!')

    while state.isConnected() :
      zee.waitForData()
      state = zee.getState()

#      print "button mask %d" % state.getButtonMask()

      # Adjust sign and axis association here in order
      # to keep the code taken from wiicontrol below.
      gy=-state.getX()
      gx=-state.getY()

#      print str(gx)+ " " + str(gy)

      #X is positive
      if gx > TOLERANCE and not xpon:
        xpon = True
        self.control.ExecuteScript(mapping["GU"])               
      if xpon and gx < TOLERANCE and gx > -TOLERANCE:
        xpon = False
        self.control.ExecuteReleasedScript(mapping["GU"])
      #X is negative
      if gx < -TOLERANCE and not xnon:
        xnon = True
        self.control.ExecuteScript(mapping["GD"])
      if xnon and gx < TOLERANCE and gx > -TOLERANCE:
        xnon = False
        self.control.ExecuteReleasedScript(mapping["GD"])
             
      #Y is positive
      if gy > TOLERANCE and not ypon:
        ypon = True
        self.control.ExecuteScript(mapping["GL"])
      if ypon and gy < TOLERANCE and gy > -TOLERANCE:
        ypon = False
        self.control.ExecuteReleasedScript(mapping["GL"])
      #Y is negative
      if gy < -TOLERANCE and not ynon:
        ynon = True
        self.control.ExecuteScript(mapping["GR"])
      if ynon and gy < TOLERANCE and gy > -TOLERANCE:
        ynon = False
        self.control.ExecuteReleasedScript(mapping["GR"])

      buttonmask = state.getButtonMask()
      for bb in buttons:
        if (buttonmask & buttonmap[bb]):          
          if useAlt:
            self.control.ExecuteScript(altMapping[bb])
            pressed[bb]=True                      
          else:
            self.control.ExecuteScript(mapping[bb])
            pressed[bb]=True
        elif (not (buttonmask & buttonmap[bb])):
          if pressed[bb]==True:
            pressed[bb]=False                          
            self.control.ExecuteReleasedScript(mapping[bb])

      while gtk.events_pending():
      	gtk.main_iteration()                

    print "Leaving event thread..."
    gtk.main_quit()

