# To generate X-window events, we use XTest library
# Use XTest extensions, by directly loading the shared library
import time
from ctypes import CDLL
Xtst = CDLL("libXtst.so.6")
Xlib = CDLL("libX11.so.6")

class XControl():
  def __init__(self):
    # Get the current display
    self.d = Xtst.XOpenDisplay(None)

  # Generate a keypress, given the keyname.
  def SendKey(self, key):
    sym = Xlib.XStringToKeysym(key)
    code = Xlib.XKeysymToKeycode(self.d, sym)
    Xtst.XTestFakeKeyEvent(self.d, code, True, 0)
    Xtst.XTestFakeKeyEvent(self.d, code, False, 0)
    Xlib.XFlush(self.d)

  def SendKeyDown(self, key):
    sym = Xlib.XStringToKeysym(key)
    code = Xlib.XKeysymToKeycode(self.d, sym)
    Xtst.XTestFakeKeyEvent(self.d, code, True, 0)
    Xlib.XFlush(self.d)

  def SendKeyUp(self, key):
    sym = Xlib.XStringToKeysym(key)
    code = Xlib.XKeysymToKeycode(self.d, sym)
    Xtst.XTestFakeKeyEvent(self.d, code, False, 0)
    Xlib.XFlush(self.d)

  def SendCtrlKey(self, key):
    self.SendKeyDown("Control_R")
    self.SendKey(key)
    self.SendKeyUp("Control_R")

  # Move the mouse to the given (absolute) coordinates
  def MouseMove(self, x, y):
    Xtst.XTestFakeMotionEvent(self.d, -1, x, y, 0);
    Xlib.XFlush(self.d)

  def MouseMoveRelative(self, x, y):
    Xtst.XTestFakeRelativeMotionEvent(self.d, -1, x, y, 0);
    Xlib.XFlush(self.d)

  # Click a mouse button (1:left, 2:right)
  def MouseClick(self, button):
    Xtst.XTestFakeButtonEvent( self.d, button, True, 0 );
    Xtst.XTestFakeButtonEvent( self.d, button, False, 0 );
    Xlib.XFlush(self.d)

  def StylusTap(self, x, y):
    Xtst.XTestFakeMotionEvent(self.d, -1, x, y, 0)
    Xtst.XTestFakeButtonEvent(self.d, 1, True, 0 );
    Xtst.XTestFakeButtonEvent(self.d, 1, False, 0 );
    Xlib.XFlush(self.d)

# Given a list of strings, each one being a valid command, execute the script
# Valid commands are:
#   "k name"   -> Sendkey(name)
#   "m x y"    -> MouseMove(x,y)
#   "b button" -> MouseClick(button)
#   "t x y"    -> StylusTap(x,y)
#   "s time"   -> sleep(time)
  def ExecuteScript(self, script):
    for c in script:
      cmd=c.split()
      if cmd[0]=='k':
        aux=cmd[1].split('-')
        if len(aux)==1:
          self.SendKey(cmd[1])
        else:
          self.SendCtrlKey(aux[1])
      elif cmd[0]=='a':
        self.SendKeyDown(cmd[1])              
      elif cmd[0]=='b':
        self.MouseClick(int(cmd[1]))
      elif cmd[0]=='m':
        self.MouseMove(int(cmd[1]), int(cmd[2]))
      elif cmd[0]=='r':
        self.MouseMoveRelative(int(cmd[1]), int(cmd[2]))
      elif cmd[0]=='t':
        self.StylusTap(int(cmd[1]), int(cmd[2]))
      elif cmd[0]=='s':
        sleep(float(cmd[1]))
      else: break

  def ExecuteReleasedScript(self, script):
    for c in script:
      cmd=c.split()  
      if cmd[0]=='a':
        self.SendKeyUp(cmd[1])
      else: break
