import gtk
import gtk.gdk
from gtk import gdk
import xml.dom.minidom,os
from xml.dom.minidom import Node
import httplib
import osmgpsmap
import math
import cairo
import time
import hildon
import gobject

from threading import Thread


def decode_line(encoded):

    """Decodes a polyline that was encoded using the Google Maps method.

    See http://code.google.com/apis/maps/documentation/polylinealgorithm.html

    This is a straightforward Python port of Mark McClure's JavaScript polyline decoder
    (http://facstaff.unca.edu/mcmcclur/GoogleMaps/EncodePolyline/decode.js)
    and Peter Chng's PHP polyline decode
    (http://unitstep.net/blog/2008/08/02/decoding-google-maps-encoded-polylines-using-php/)
    """

    encoded_len = len(encoded)
    index = 0
    array = []
    lat = 0
    lng = 0

    while index < encoded_len:

        b = 0
        shift = 0
        result = 0

        while True:
            b = ord(encoded[index]) - 63
            index = index + 1
            result |= (b & 0x1f) << shift
            shift += 5
            if b < 0x20:
                break

        dlat = ~(result >> 1) if result & 1 else result >> 1
        lat += dlat

        shift = 0
        result = 0

        while True:
            b = ord(encoded[index]) - 63
            index = index + 1
            result |= (b & 0x1f) << shift
            shift += 5
            if b < 0x20:
                break

        dlng = ~(result >> 1) if result & 1 else result >> 1
        lng += dlng

        array.append((lat * 1e-5, lng * 1e-5))

    return array

class MyZoomSelect(gtk.Dialog):

    def act_download(self,widget):
        self.p.zoom_min = int(self.h_min.get_value())
        self.p.zoom_max = int(self.h_max.get_value())
        self.destroy()

    def __init__(self, p):
        self.p = p

        gtk.Dialog.__init__(self)
        self.set_title("Select zoom to download")
        self.set_size_request(640, 480)

        self.h_min = gtk.HScale()
        self.h_min.set_range(1,18)
        self.h_min.set_value(11)
        self.vbox.pack_start( self.h_min, True,True,0)

        self.h_max = gtk.HScale()
        self.h_max.set_range(1,18)
        self.h_max.set_value(16)
        self.vbox.pack_start( self.h_max, True,True,0)

        bt_download = gtk.Button("Download")
        bt_download.connect("clicked", self.act_download)
        self.vbox.pack_start( bt_download, True, True, 0)

        self.show_all()


class googleRoutesearchDownloader(Thread):
    def __init__(self,geonames,config, offline, z_min, z_max):
        Thread.__init__(self)
        self.geonames = geonames
        self.osmMapa = self.geonames.osmMapa
        self.CONFIG = config
        self.offline = offline
        self.zoom_min = z_min
        self.zoom_max = z_max

    def parseXml(self, xml_res):
        doc = xml.dom.minidom.parseString(xml_res)

        step_count = 0
        self.geonames.points = []

        download_offline = 0
        if self.offline:
            download_offline = 1


        if doc.getElementsByTagName("status")[0].childNodes[0].data == "ZERO_RESULTS":
            self.osmMapa.showBanner("No results :/ ZERO, NADA")
            return None

        for step in doc.getElementsByTagName("step"):

            sl = step.getElementsByTagName("start_location")[0]
            el = step.getElementsByTagName("end_location")[0]

            sll = [ sl.getElementsByTagName("lat")[0].childNodes[0].data, sl.getElementsByTagName("lng")[0].childNodes[0].data]
            ell = [ el.getElementsByTagName("lat")[0].childNodes[0].data, el.getElementsByTagName("lng")[0].childNodes[0].data]

            str = step.getElementsByTagName("html_instructions")[0].childNodes[0].data.replace("<b>","").replace("</b>","")
            ico = None

            if str.find("Continue straight") == 0:
                ico = gdk.pixbuf_new_from_file("./plugins/ico_turn_32_32.png")
            elif str.find("Turn left") == 0:
                ico = gdk.pixbuf_new_from_file("./plugins/ico_turn_left_32_32.png")
            elif str.find("Turn right") == 0:
                ico = gdk.pixbuf_new_from_file("./plugins/ico_turn_right_32_32.png")
            elif str.find("Slight right") == 0:
                ico = gdk.pixbuf_new_from_file("./plugins/ico_turn_sright_32_32.png")
            elif str.find("Slight left") == 0:
                ico = gdk.pixbuf_new_from_file("./plugins/ico_turn_sleft_32_32.png")
            self.geonames.markers.append([
                                 float(sll[0]),float(sll[1]),
                                 str,
                                 ico
                                 ])

            t = osmgpsmap.GpsMapTrack()
            t.props.color = gtk.gdk.color_parse("#1a39fb")

            self.geonames.tracks.append( t )
            point0 = osmgpsmap.point_new_degrees(float(sll[0]),float(sll[1]))
            point1 = osmgpsmap.point_new_degrees(float(ell[0]),float(ell[1]))
            t.add_point( point0 )
            self.geonames.points.append( [float(sll[0]),float(sll[1])] )



            points = step.getElementsByTagName("points")[0].childNodes[0].data
            if len(points) > 2:
                a = decode_line( points )
                print "points from points in poliline", len( a )
                for p in a:
                    point0 = osmgpsmap.point_new_degrees(float(p[0]),float(p[1]))
                    self.geonames.points.append( [float(p[0]),float(p[1])] )
                    t.add_point( point0 )

                    if download_offline:
                        self.osmMapa.osm.download_maps(
                               float(p[0]),float(p[1]),
                               float(p[0]),float(p[1]),
                               self.zoom_min,self.zoom_max
                               )


            t.add_point( point1 )
            self.geonames.points.append( [float(ell[0]),float(ell[1])] )
            self.osmMapa.osm.track_add( t )

            if step_count == 0:
                i = gdk.pixbuf_new_from_file("./plugins/ico_comment_g.png")
                self.geonames.icons.append( self.osmMapa.osm.image_add( float(sll[0]),float(sll[1]), i ) )

            step_count+=1

        try:
            i = gdk.pixbuf_new_from_file("./plugins/ico_comment_m.png")
            self.geonames.icons.append( self.osmMapa.osm.image_add( float(ell[0]),float(ell[1]), i ) )
        except:
            pass

        print "step added ", step_count







    def downloadXml(self):
        """
        maps.googleapis.com/maps/api/directions/xml?&destination=Polska,Pozna%C5%84,os.Stare%20%C5%BBegrze&waypoints=Polska,Pozna%C5%84,ul.%20g%C5%82ogowska%2010&sensor=false
        """
        conn = httplib.HTTPConnection("maps.googleapis.com")
        start = self.CONFIG['google_routesearch_from']
        end = self.CONFIG['google_routesearch_to']

        if start == "my current location":
            lat, lon = self.osmMapa.get_may_current_ll()
            start = "loc:%f+%f"%( float(lat), float(lon)  )
        if end == "my current location":
            lat, lon = self.osmMapa.get_may_current_ll()
            end = "loc:%f+%f"%( float(lat), float(lon)  )

        req = "/maps/api/directions/xml?mode=%s&origin=%s&destination=%s&sensor=true" % (self.geonames.mode[self.CONFIG['google_routesearch_mode']],start,end)
        print req
        req = req.replace(" ", "%20")
        conn.request("GET", req)
        r = conn.getresponse()
        return r.read()


    def run(self):
        print "googleRoutesearchDownloader downolad"
        res = self.downloadXml()
        print "googleRoutesearchDownloader parse"
        self.parseXml( res )


class SaveTrackDialog( hildon.Program):
    def __init__(self, zoom=0, lat=0, lon=0):
        hildon.Program.__init__(self)
        self.app = hildon.Program()
        self.window = hildon.Window()

    def startIt(self):
        dlg = gobject.new(hildon.FileChooserDialog, action=gtk.FILE_CHOOSER_ACTION_SAVE)
        #hildon.FileChooserDialog(self.window, gtk.FILE_CHOOSER_ACTION_SAVE)
        czas = time.strftime("%Y%m%d_%H%M.gpx", time.localtime() )
        #dlg.set_current_folder("/home/user/MyDocs")
        dlg.set_current_name(czas)
        response = dlg.run()
        if response == gtk.RESPONSE_OK:
            tr = dlg.get_filename()
        else:
            tr = ""
        dlg.hide()
        return tr


class google_routesearch:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG
        self.osmMapa = osmMapa

        self.tp = ""
        self.timeout = 5
        self.draw = 0
        self.ll = 0,0

        self.tracks = []
        self.tracks_on_map = []
        self.points = []
        self.markers = []
        self.markers_icons = []

        self.icons = []

        self.zoom_minimum = 15
        self.zoom_min = 10
        self.zoom_max = 16

        #self.ico = "google_routesearch.png"

        try:
            print "google_routesearch last search:", self.CONFIG['google_routesearch_from']
        except:
            self.CONFIG['google_routesearch_from'] = ""
        try:
            print "google_routesearch last search:", self.CONFIG['google_routesearch_to']
        except:
            self.CONFIG['google_routesearch_to'] = ""

        try:
            print "google_routesearch mode:", self.CONFIG['google_routesearch_mode']
        except:
            self.CONFIG['google_routesearch_mode'] = 0

        self.mode = ["driving", "walking", "bicycling"]

        print "__init__ google routesearch"


    def makeInit(self):
        pass

    def get_name(self):
        return "Google - routesearch"

    def do_draw(self, gpsmap, gdkdrawable):
        if self.osmMapa.osm.props.zoom>self.zoom_minimum:
            if len( self.markers_icons ) == 0:
                for p in self.markers:
                    if p[3] <> None:
                        self.markers_icons.append( self.osmMapa.osm.image_add( p[0], p[1], p[3] ) )

            t_lt, t_ln, b_lt, b_ln = self.osmMapa.osm.get_bbox()
            t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)

            cr = gdkdrawable.cairo_create()

            for p in self.markers:
                lt = p[0]
                ln = p[1]
                #print "lt:",t_lt,t_ln,"\t c:",lt,ln,"\tb:",b_lt,b_ln
                if t_ln < ln and b_ln > ln and t_lt > lt and b_lt < lt:
                    x,y = self.osmMapa.osm.geographic_to_screen(lt,ln)
                    self.osmMapa.draw_cloud( cr, x,y, p[2])
        else:
            for i in self.markers_icons:
                self.osmMapa.osm.image_remove( i )
            self.markers_icons = []


    def clean_layer(self):
        for i in self.markers_icons:
            self.osmMapa.osm.image_remove( i )
        self.markers_icons = []

        for t in self.tracks:
            self.osmMapa.osm.track_remove( t )
        self.tracks = []

        for i in self.icons:
            self.osmMapa.osm.image_remove( i )
        self.icons = []

        self.markers = []

    def on_clear(self, w, dialog):
        self.clean_layer()
        dialog.destroy()

    def search_action(self):
        self.clean_layer()

        try:
            if self.bt_offline.get_active():
                zoom_dialog = MyZoomSelect(self)
                zoom_dialog.run()
        except:
            self.bt_offline = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        self.osmMapa.showBanner(("searching route...\nfrom: %s\nto: %s" % (self.CONFIG['google_routesearch_from'],self.CONFIG['google_routesearch_to'])))
        t = googleRoutesearchDownloader( self, self.CONFIG, self.bt_offline.get_active(), self.zoom_min, self.zoom_max )
        t.start()

        #xml_res = self.downloadXml()
        #print xml_res
        #self.parseXml( xml_res )
        try:
            dialog.destroy()
        except:
            pass

    def on_search(self,w,dialog):
        print "search route start"
        self.CONFIG['google_routesearch_from'] = self.e_start.get_text()
        self.CONFIG['google_routesearch_to'] = self.e_end.get_text()


        self.search_action()

    def on_swap(self, w ):
        a = self.e_start.get_text()
        self.e_start.set_text( self.e_end.get_text() )
        self.e_end.set_text( a )

        self.CONFIG['google_routesearch_from'] = self.e_start.get_text()
        self.CONFIG['google_routesearch_to'] = self.e_end.get_text()

    def on_clean(self,w):
        self.e_start.set_text("my current location")
        self.e_end.set_text("")

        self.CONFIG['google_routesearch_from'] = self.e_start.get_text()
        self.CONFIG['google_routesearch_to'] = self.e_end.get_text()

    def on_add(self, w):
        if self.e_start.is_focus():
            self.e_start.set_text( "loc:%f+%f"%(self.osmMapa.osm.props.latitude, self.osmMapa.osm.props.longitude) )
            self.CONFIG['google_routesearch_from'] = self.e_start.get_text()
        else:
            self.e_end.set_text( "loc:%f+%f"%(self.osmMapa.osm.props.latitude, self.osmMapa.osm.props.longitude) )
            self.CONFIG['google_routesearch_to'] = self.e_end.get_text()
    def on_changed_mode (self,picker):
        str = picker.get_value()
        id = -1
        iter = 0
        for mode_name in self.mode:
            if mode_name == str:
                id = iter
                break
            else:
                iter+=1
        print "selected mode: ", self.mode[id]
        self.CONFIG['google_routesearch_mode'] = id

    def on_bt_export(self,w, dialog):
        dialog.destroy()
        d = SaveTrackDialog()
        file = d.startIt()
        print "file to load", file
        if file <> "":
            print "export export export "
            f = open( file, "w")
            f.write("""<?xml version="1.0"?>
<gpx creator="yosmapa" version="1.0">""" )

            for p in self.markers:
                f.write("""
<wpt lat="%f" lon="%f">
  <name>%s</name>
  <sym>http://maps.gstatic.com/intl/pl_ALL/mapfiles/ms/micons/blue-dot.png</sym>
</wpt>""" %( p[0],p[1],p[2]) )


            f.write("""<trk>
    <name>Line 1</name>
    <trkseg>
""")
            for p in self.points:
                f.write("        <trkpt lat=\"%f\" lon=\"%f\"></trkpt>\n"%(p[0],p[1]))
            f.write("""    </trkseg>
</trk>
</gpx>"""         )
            f.close()

    def get_menu_widgets(self, dialog):
        vbox = gtk.VBox()

        self.e_start = gtk.Entry()
        self.e_start.set_text(self.CONFIG['google_routesearch_from'])
        vbox.pack_start(self.e_start, True)

        self.e_end = gtk.Entry()
        self.e_end.set_text(self.CONFIG['google_routesearch_to'])
        vbox.pack_start(self.e_end, True)


        hbox = gtk.HBox()
        pb_mode = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,
                                        hildon.BUTTON_ARRANGEMENT_VERTICAL)
        pb_mode.set_title("Transport mode")
        selector_mode = hildon.TouchSelectorEntry(text=True)
        mode_set_id = 0
        iter_nr = 0
        for mode_name in self.mode:
            selector_mode.append_text(mode_name)
        pb_mode.set_selector(selector_mode)
        pb_mode.set_active( self.CONFIG['google_routesearch_mode'] )
        pb_mode.connect("value-changed",self.on_changed_mode)
        hbox.pack_start( pb_mode, True )

        self.bt_offline = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        self.bt_offline.set_label("work offline")
        hbox.pack_start(self.bt_offline, True)
        vbox.pack_start( hbox, True )


        hbox = gtk.HBox()

        bt_a = gtk.Button(stock=gtk.STOCK_ADD)
        bt_a.connect("clicked", self.on_add)
        hbox.pack_start( bt_a, True)


        bt_c = gtk.Button(stock=gtk.STOCK_CLEAR)
        bt_c.connect("clicked", self.on_clean)
        hbox.pack_start( bt_c, True)


        bt_swap = gtk.Button("swap points")
        bt_swap.connect("clicked", self.on_swap)
        hbox.pack_start( bt_swap, True)

        bt_search = gtk.Button(stock=gtk.STOCK_FIND)
        bt_search.connect("clicked", self.on_search, dialog)
        hbox.pack_start( bt_search, True)

        if len( self.tracks ):
            bt_clear = gtk.Button("clear")
            bt_clear.connect("clicked", self.on_clear, dialog)
            hbox.pack_start( bt_clear, True)


        vbox.pack_start(hbox, True)


        if len( self.tracks ):
            bt_export = gtk.Button("Export route to gpx")
            bt_export.connect("clicked", self.on_bt_export, dialog )
            vbox.pack_start( bt_export, True)

        return vbox

    def do_render(self, gpsmap):
        pass

    def do_busy(self):
        return False

    def do_button_press(self, gpsmap, gdkeventbutton):
        pass