#ifndef _FOO_GLUE_H_FOO_
#define _FOO_GLUE_H_FOO_

#include <hildon/hildon.h>

#include "audio.h"

struct yaspot_glue_t;
typedef struct yaspot_glue_t yaspot_glue_t;

struct yaspot_glue_response_t;
typedef struct yaspot_glue_response_t yaspot_glue_response_t;

typedef void (*yaspot_glue_state_changed_t)(gboolean playing, gboolean paused, gpointer data);
/* This trigger calls about once in a second. */
typedef void (*yaspot_glue_timer_update_t)(yaspot_glue_t *t, gint now, gint length, gpointer data);

void yaspot_glue_add_state_cb(yaspot_glue_t *t, yaspot_glue_state_changed_t callback, gpointer userdata);
void yaspot_glue_del_state_cb(yaspot_glue_t *t, yaspot_glue_state_changed_t callback, gpointer userdata);
/* When called with NULL callback, callback is reset. */
void yaspot_glue_set_timer_cb(yaspot_glue_t *t, yaspot_glue_timer_update_t callback, gpointer userdata);

yaspot_glue_t* yaspot_glue_init(DBusConnection *dbus);
int yaspot_glue_cleanup(yaspot_glue_t *t);

int yaspot_glue_auth(yaspot_glue_t *t, const gchar *username, const gchar *password, gint high_bitrate);
void yaspot_glue_print_info(yaspot_glue_t *t);

/* search & artist or album from playlist
 * returns GLUE_LIST type object
 * */
yaspot_glue_response_t* yaspot_glue_search(yaspot_glue_t *t, const gchar *search, gint maxresults);

/* get in num track artist response (start from 1)
 * return GLUE_ARTIST type object
 */
yaspot_glue_response_t* yaspot_glue_artist(yaspot_glue_response_t *r, gint num);
/* get max_chars length of current response artist description, -1 for full text,
 * return NULL if no description available */
gchar* yaspot_glue_artist_description(yaspot_glue_response_t *r, gint max_chars);
int yaspot_glue_artist_num_albums(yaspot_glue_response_t *r);
yaspot_glue_response_t* yaspot_glue_artist_album(yaspot_glue_response_t *r, gint num);
/* get in num track album response (start from 1)
 * return GLUE_ALBUM type object
 */
yaspot_glue_response_t* yaspot_glue_album(yaspot_glue_response_t *r, gint num);

gboolean yaspot_glue_album_from_artist(yaspot_glue_response_t *album, yaspot_glue_response_t *artist);
gboolean yaspot_glue_album_is_single(yaspot_glue_response_t *r, gint single_limit);
gboolean yaspot_glue_album_is_compilation(yaspot_glue_response_t *r, gint artist_limit);
int yaspot_glue_album_year(yaspot_glue_response_t *r);

gint yaspot_glue_res_n_tracks(yaspot_glue_response_t *r);

/* get all stored playlists
 * returns GLUE_PLAYLISTS type object
 */
yaspot_glue_response_t* yaspot_glue_stored_lists(yaspot_glue_t *t);

/* get nth playlist from list of playlists (start from 1)
 * returns GLUE_LIST type object
 */
yaspot_glue_response_t* yaspot_glue_stored_playlist(yaspot_glue_response_t *r, gint num);

//gchar* yaspot_glue_response_

/* save whatever response data to model data */
void yaspot_glue_response_to_model(yaspot_glue_response_t *r, GtkListStore *model);
void yaspot_glue_response_to_queue_model(yaspot_glue_response_t *r, GtkListStore *model);

/* get whatever "name" associated to response object.
 * caller must free received string
 */
gchar* yaspot_glue_response_get_name(yaspot_glue_response_t *r);

void* yaspot_glue_get_image(yaspot_glue_response_t *r, gint *len);

int yaspot_glue_response_ref(yaspot_glue_response_t *r);
int yaspot_glue_response_unref(yaspot_glue_response_t *r);

int yaspot_glue_play(yaspot_glue_response_t *r, gint num);
int yaspot_glue_res_stop(yaspot_glue_response_t* t);
int yaspot_glue_stop(yaspot_glue_t* t);
int yaspot_glue_set_pause(yaspot_glue_t *t, gboolean pause);
int yaspot_glue_next(yaspot_glue_t *t);
int yaspot_glue_prev(yaspot_glue_t *t);

/* returns currently active playing queue and references it bt 1.
 * caller should unref response object after use. */
yaspot_glue_response_t* yaspot_glue_current_queue(yaspot_glue_t *t);
yaspot_glue_response_t* yaspot_glue_res_current_queue(yaspot_glue_response_t *r);

gboolean yaspot_glue_playing(yaspot_glue_t *t);
gchar* yaspot_glue_current_track(yaspot_glue_t *t);

/* current active playlist track number, counting starts from 1 */
gint yaspot_glue_current_track_num(yaspot_glue_t *t);

#endif

// vim: expandtab shiftwidth=4

