#ifndef _FOO_USERDATA_H_FOO_
#define _FOO_USERDATA_H_FOO_

#include <hildon/hildon.h>
#include <libosso.h>
#include <dbus/dbus.h>

#include "glue.h"

/* view internals */

/* main view */
typedef struct view_main_t {
    GtkWidget *window;
    GtkWidget *entry_search;
} view_main_t;

typedef struct connection_t {
    gint connected;

} connection_t;

typedef struct userdata_t {
    HildonProgram *program;
    osso_context_t *osso;
    DBusConnection *dbus;

    /* views */
    view_main_t main;

    /* despotify related */
    connection_t connection;
    yaspot_glue_t *session;

    /* display state */
    gboolean display_on;

    /* app-menu-stuff */
    HildonAppMenu *app_menu;
    /* buttons */
    GtkWidget *playpause;
    GtkWidget *prev;
    GtkWidget *next;
    GtkWidget *queue;

} userdata_t;

#endif

// vim: expandtab

