from PyQt4 import uic
from PyQt4.QtCore import *
from xbmcpotatolib import *
from PyQt4.QtGui import * 
from PyQt4 import QtCore
from PyQt4.QtCore import QEvent
import simplejson
import copy
from copy import deepcopy
import XBMCMessageClass
import threading
import time
import traceback
import xpot_config
import sys
from avr import YamahaRXVClient
import inspect

(Ui_XPotToolsDialog, QDialog) = uic.loadUiType('xpot_toolsdialog.ui')
class XPotToolsDialog (QDialog):
    
    def __init__(self, parent):
        QDialog.__init__(self, parent)
        self.ui = Ui_XPotToolsDialog()
        self.ui.setupUi(self)
        self.setWindowTitle("Settings")
        self.config = xpot_config.XPotConfig(self)
        self.config.readConfig()
        self.populateScreenFields()


    def populateScreenFields(self):
        #--[connection]
        self.ui.lineEditServer.setText(self.config.server)
        self.ui.lineEditPort.setText(self.config.port)
        self.ui.lineEditUser.setText(self.config.user)
        self.ui.lineEditPassword.setText(self.config.password)
        
        #--[AVR]
        self.ui.lineEditServerAVR.setText(self.config.serverAVR)
        self.ui.lineEditPortAVR.setText(self.config.portAVR)
        self.ui.comboBoxSourceAVR.clear()
        for name, data in inspect.getmembers(YamahaRXVClient.YamahaRXVClient, inspect.ismethod):
            if name == '__builtins__':
                continue
            if name.startswith('input'):
                self.ui.comboBoxSourceAVR.addItem(name.rsplit('input')[1])
        ix = 0
        while ix < self.ui.comboBoxSourceAVR.count():
            if self.ui.comboBoxSourceAVR.itemText(ix) == self.config.sourceAVR:             
                self.ui.comboBoxSourceAVR.setCurrentIndex(ix)
            ix = ix + 1                

        #--[features]
        if self.config.powerOnAVR == 'True':
            self.ui.checkBoxPowerOnAVR.setChecked(True)
        else:
            self.ui.checkBoxPowerOnAVR.setChecked(False)
            
        if self.config.switchSourceAVR == 'True':
            self.ui.checkBoxSwitchSourceAVR.setChecked(True)
        else:
            self.ui.checkBoxSwitchSourceAVR.setChecked(False)
            
        if self.config.volumeControl == 'AVR':
            self.ui.radioButtonVolAVR.setChecked(True)
        else:
            self.ui.radioButtonVolXBMC.setChecked(True)
            
        if self.config.powerOnXBMC == 'True':
            self.ui.checkBoxPowerOnXBMC.setChecked(True)
            
        self.ui.lineEditXBMCMac.setText(self.config.XBMCMac)
        self.ui.spinBoxPowerOnXBMCTimeout.setValue(int(self.config.powerOnXBMCTimeout))
    
    def updateConfig(self):
        #--[connection]
        self.config.server = self.ui.lineEditServer.text()
        self.config.port = self.ui.lineEditPort.text()
        self.config.user = self.ui.lineEditUser.text()
        self.config.password = self.ui.lineEditPassword.text()
        
        #--[AVR]
        self.config.serverAVR = self.ui.lineEditServerAVR.text()
        self.config.portAVR = self.ui.lineEditPortAVR.text()
        self.config.sourceAVR = self.ui.comboBoxSourceAVR.currentText()
          
        #--[features]
        self.config.powerOnAVR = str(self.ui.checkBoxPowerOnAVR.isChecked())
        self.config.switchSourceAVR = str(self.ui.checkBoxSwitchSourceAVR.isChecked())
        if self.ui.radioButtonVolAVR.isChecked():
            self.config.volumeControl = 'AVR'
        else:
            self.config.volumeControl = 'XBMC'

        self.config.powerOnXBMC = str(self.ui.checkBoxPowerOnXBMC.isChecked())
        self.config.XBMCMac = self.ui.lineEditXBMCMac.text()
        self.config.powerOnXBMCTimeout = str(self.ui.spinBoxPowerOnXBMCTimeout.value())

        self.config.writeConfig()             