from PyQt4 import uic
from PyQt4.QtCore import *
from xbmcpotatolib import *
import tools_dialog
from PyQt4.QtGui import * 
from PyQt4 import QtCore
from PyQt4.QtCore import QEvent
import simplejson
import copy
from copy import deepcopy
import XBMCMessageClass
import threading
import time
import traceback
from xpot_config import *
from avr import YamahaRXVClient
from time import sleep
import socket
from telnetlib import Telnet

class TrackChangedEvent(QEvent):
	def __init__(self, ix):
		QEvent.__init__(self, QEvent.User+0)
		self.ix = ix
		
	def setCurrentSongIndex(self, ix):
		self.ix = ix
	
	def getCurrentSongIndex(self):
		return self.ix
	

class CurrentSongThread ( QThread ):
	def __init__(self,xbmc,gui):
		QThread.__init__(self)
		self.xbmc = xbmc
		self.gui = gui
		self.abort = False
		self.playerStopped = False
		
	def run (self):
		while self.abort == False:
			if self.playerStopped == False:
				self.getCurrentSong()
			time.sleep(1)
		
	def abortThread(self):
		self.abort = True
		
	def getCurrentSong(self):
		res = self.xbmc.getCurrentSong()
		try:
			self.event = TrackChangedEvent('-1')			
			self.event.setCurrentSongIndex(res.MResult)
			qApp.postEvent(self.gui,self.event)
		except:
			print "Failed to get Current Song"	
			traceback.print_exc(None, None)


(Ui_XPotMainWindow, QMainWindow) = uic.loadUiType('xpot_mainwindow.ui')
class XPotMainWindow (QMainWindow):
	"""XPotMainWindow inherits QMainWindow"""
	def __init__ (self, parent = None):
		self.version = "0.2"
		self.name = "XBMC Potato"
		self.developer = "Yiannis Petevis"
		self.email = "y.petevis@gmail.com"
		QMainWindow.__init__(self, parent)
		self.setWindowTitle(self.name)
		
		self.progDialog = QProgressDialog(self)
		self.progDialog.setAutoReset(True)
		self.progDialog.setAutoClose(True)
		self.progDialog.setMinimum(0)
		self.progDialog.setMaximum(100)
		self.progDialog.setWindowModality(QtCore.Qt.WindowModal)
		self.progDialog.setCancelButton(None)
		self.progDialog.show()
		self.progDialog.setWindowTitle("Starting Up...")		
		self.progDialog.setValue(10)			
		self.showFullScreen()
		self.fullScreen = True	
		self.ui = Ui_XPotMainWindow()
		self.ui.setupUi(self)
		self.config = XPotConfig(None)
		
		self.ui.treeWidget.setColumnCount(1)
		self.mapper = QSignalMapper(self)
		self.mapper.mapped[str].connect(self.navButtonclick)
		self.signalWiring()
		self.xbmc = XBMCLib(self.config.server, self.config.port, self.config.user, self.config.password)			
		if self.config.server == "":
			self.progDialog.setValue(100)	
			qd = QMessageBox(self)
			qd.setText("XBMC Potato has not been configured yet.  Click OK to configure now and restart the application.")
			qd.exec_()
			self.showToolsDialog()
			return

		start = time.time()
		while self.isXBMCPoweredOn() == False:
			if self.config.powerOnXBMC == 'True':
				self.progDialog.setWindowTitle("Powering On XBMC")		
				self.progDialog.setValue(20)							
				self.XBMCWakeOnLan()
				sleep(5)
			else:
				self.progDialog.setWindowTitle("Waiting for XBMC to respond...")		
				self.progDialog.setValue(20)					
			#self.isXBMCPoweredOn()
			end = time.time()
			elapsed = end - start
			if elapsed >= int(self.config.powerOnXBMCTimeout):
				break

		self.currentSongIx = -1		
		if self.isXBMCPoweredOn():
			self.progDialog.setWindowTitle("Retrieving Media Shares")		
			self.progDialog.setValue(30)			
			self.getMusicShareDirectories()
			self.progDialog.setWindowTitle("Reading Current Playlist")		
			self.progDialog.setValue(50)					
			self.getCurrentPlaylistItems()
			self.initializeNavButtons()
			self.currentSongThread = CurrentSongThread(self.xbmc,self)
			self.currentSongThread.start()
			self.setPlayButtonState()		
			trademark = QLabel()
			font = QFont()
			font.setBold(True)
			font.setItalic(True)
			font.setPointSize(9)
			trademark.setFont(font)
			trademark.setText('<font color="#4863A0">//Coded by Yiannis Petevis</font>')
			self.installEventFilter(self)
			self.initializeAVR()
			self.progDialog.setValue(100)		
		else:
			self.progDialog.setValue(100)
			qd = QMessageBox(self)
			qd.setText("Connection to XBMC failed")
			qd.exec_

	def isXBMCPoweredOn(self):
		s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
		s.settimeout(0.5)
		try:
			s.connect((self.config.server, int(self.config.port)))
			s.shutdown(2)
			return True
		except:
			return False
		
	def XBMCWakeOnLan(self):
		s=socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
		s.setsockopt(socket.SOL_SOCKET, socket.SO_BROADCAST, 1)
		ip_array = self.config.server.split(".")
		ip_array.pop(3)
		dot = "."
		ip_head = dot.join(ip_array)
		mac_hex = self.config.XBMCMac.decode("hex")
		ip_broadcast = ip_head + ".255"
		s.sendto("\xff"*6+mac_hex*16, (ip_broadcast, 9) )

	
	def initializeAVR(self):
		self.avr = YamahaRXVClient.YamahaRXVClient(self.config.serverAVR, int(self.config.portAVR))
		if self.config.powerOnAVR == 'True':
			self.progDialog.setWindowTitle("Powering On AV Receiver")		
			self.progDialog.setValue(70)			
			self.avr.powerOn()
		if self.config.switchSourceAVR == 'True':
			self.progDialog.setWindowTitle("Switching AV Receiver Source")		
			self.progDialog.setValue(90)			
			sleep(0.5)
			self.switchAVRSource()
			self.progDialog.setWindowTitle("Switching AV Receiver Source")		
	
	def switchAVRSource(self):
		switchSourceMethodName = "input%s" % self.config.sourceAVR
		switchSource = getattr(self.avr, switchSourceMethodName)
		switchSource()		
	
	def markCurrentSong(self, ix):
		try:
			if type(ix) is int:
				if self.currentSongIx <> ix:
					self.setPlayButtonState()
					self.currentSongIx = ix
					x = 0
					while x <  self.ui.treeWidgetPlaylist.topLevelItemCount():
						if x <> ix:
							color = QColor("gray")
							#self.ui.treeWidgetPlaylist.setItemSelected(self.ui.treeWidgetPlaylist.topLevelItem(x), False)
						else:
							color = QColor()
							color.setNamedColor("#FF6600")
							self.ui.treeWidgetPlaylist.scrollToItem(self.ui.treeWidgetPlaylist.topLevelItem(x))
							#self.ui.treeWidgetPlaylist.setItemSelected(self.ui.treeWidgetPlaylist.topLevelItem(x), True)
							#color.setBlue(255)
						brush = QBrush()
						brush.setColor(color)
						self.ui.treeWidgetPlaylist.topLevelItem(x).setForeground(0,brush)
						x += 1
		except:
			print "Failed to set Current Song"
			self.setPlayButtonState()
			traceback.print_exc()
	
	def initializeNavButtons(self):
		if self.ui.navLayout.count() == 0:
			rootButton = QPushButton()
			rootButton.setIcon(QIcon(":/img/user-home.png"))
			rootButton.setCheckable(True)
			#rootButton.setSizePolicy(QSizePolicy(QSizePolicy.Expanding))
			rootButton.setIconSize(QSize(32,32))
			self.ui.navLayout.addWidget(rootButton,0)
			rootButton.clicked.connect(self.mapper.map)
			self.mapper.setMapping(rootButton, "|GOTO_SHARES_ROOT")
			#spacer = QSpacerItem(0,0,QSizePolicy.Expanding,QSizePolicy.Minimum)
			#self.ui.navLayout.addSpacerItem(spacer)
	
	def getCurrentPlaylistItems(self):
		itemsList = []
		playlist_length = self.ui.treeWidgetPlaylist.topLevelItemCount()
		items = self.xbmc.getPlaylistItems()
		if items.MType == 'S':
			for item in items.MResult:
				item1 = QTreeWidgetItem()
				item1.setText(0, item["label"])
				item1.setText(1, item["file"])
				item1.setText(2, item["file"])
				itemsList.append(item1)
			ix = playlist_length + 1
			self.ui.treeWidgetPlaylist.insertTopLevelItems(ix, itemsList)
			self.ui.treeWidgetPlaylist.setColumnCount(1)
		else:
			#self.ui.statusBar.showMessage(items.MText)
			print items.MText
		
	def signalWiring(self):
		self.ui.pushButtonAdd.clicked.connect(self.addSelectedSongs)
		self.ui.pushButtonAddAll.clicked.connect(self.addAllSongs)
		self.ui.pushButtonPlay.clicked.connect(self.playSongs)
		self.ui.pushButtonStop.clicked.connect(self.stopPlaying)
		self.ui.pushButtonClear.clicked.connect(self.clearPlaylist)
		self.ui.pushButtonSkipNext.clicked.connect(self.skipNext)
		self.ui.pushButtonSkipPrevious.clicked.connect(self.skipPrevious)
		self.ui.pushButtonShuffle.toggled.connect(self.shuffle)
		self.ui.treeWidget.itemClicked.connect(self.click)
		#self.ui.treeWidget.itemActivated.connect(self.click)
		self.ui.pushButtonFullScreenToggle.clicked.connect(self.toggleFullScreen)
		self.ui.pushButtonTools.clicked.connect(self.showToolsDialog)
		self.ui.pushButtonVolUp.pressed.connect(self.volumeUp)
		self.ui.pushButtonVolUp.released.connect(self.volumeUpStop)
		self.ui.pushButtonVolDown.pressed.connect(self.volumeDown)
		self.ui.pushButtonVolDown.released.connect(self.volumeDownStop)
	

	def __del__ (self):
		self.ui = None

	def getMusicShareDirectories(self):
		#self.ui.statusBar.clearMessage()
		self.ui.treeWidget.clear()
		shares=self.xbmc.getMusicSources()
		if shares.MType == 'S':
			for item in shares.MResult:
				msobject = self.xbmc.getMusicSourceObjects(item['file'])
				if "directories" in msobject.MResult:
					self.addNavigatorRows(msobject, "directories")
				if "files" in msobject.MResult:
					self.addNavigatorRows(msobject.MResult, "files")
		else:
			#self.ui.statusBar.showMessage(shares.MText)
			print shares.MText	

	def addNavigatorRows(self, msobject, type):
		#self.ui.treeWidget.setFlags(Qt.ItemIsUserCheckable)
		for item in msobject.MResult[type]:
			item1 = QTreeWidgetItem()
			item1.setText(0, item["label"])
			item1.setText(1, item["file"])
			item1.setText(2, type)
			#item1.setForeground(0,brush)			
			
			if type == "files":
				#item1.setFlags(Qt.ItemIsUserCheckable|Qt.ItemIsEnabled|Qt.ItemIsSelectable)
				item1.setFlags(Qt.ItemIsEnabled|Qt.ItemIsSelectable)
				item1.setCheckState(0,Qt.Unchecked);
			else:
				item1.setFlags(Qt.ItemIsUserCheckable|Qt.ItemIsEnabled|Qt.ItemIsSelectable)
				item1.setCheckState(0,Qt.Unchecked);
				
			##color = QColor()
			#color.setNamedColor("#787878")
			#color.setAlpha(50)
			##brush = QBrush()
			#brush.setColor(color)
			##itImg = QImage(":/img//metallic-holes-texture.jpg")
			##brush.setTextureImage(itImg)
			##item1.setBackground(0,brush)
			#item1.setBackgroundColor(0,color)
	
			self.ui.treeWidget.addTopLevelItem(item1)
			#self.ui.treeWidget.setProperty("FingerScrollable", True)

	def getDirectory(self, dir):
		msobject = self.xbmc.getMusicSourceObjects(dir)
		if msobject.MType == 'S':
			self.ui.treeWidget.clear()
			if "directories" in msobject.MResult:
				self.addNavigatorRows(msobject, "directories")
				self.ui.treeWidget.setSelectionMode(QAbstractItemView.SingleSelection)				
			if "files" in msobject.MResult:
				self.addNavigatorRows(msobject, "files")
				self.ui.treeWidget.setSelectionMode(QAbstractItemView.SingleSelection) 
			self.ui.treeWidget.sortItems(0,Qt.AscendingOrder)
			#self.ui.treeWidget.setProperty("FingerScrollable", True)		

	
	def setPlayButtonState(self):
		try:
			playing = self.xbmc.getAudioPlayerState().MResult["playing"]
			paused = self.xbmc.getAudioPlayerState().MResult["paused"]
		except:
			playing = False
			paused = False
		if playing == True and paused == False:
			self.ui.pushButtonPlay.setIcon(QIcon(":/img//media-playback-pause.png"))
			self.ui.pushButtonPlay.setProperty("Paused",False)
			self.currentSongThread.playerStopped = False
		else:
			self.ui.pushButtonPlay.setIcon(QIcon(":/img//media-playback-start.png"))
			self.ui.pushButtonPlay.setProperty("Paused",True)
			self.currentSongThread.playerStopped = True
		if playing == False:
			return True
		else:
			return False


	def increaseVolumeThread(self):
		while self.increaseVolume:
			if self.config.volumeControl == 'AVR':			
				self.avr.volumeUp()
			else:
				self.xbmc.volumeUp()
			sleep(0.1)
	
	def decreaseVolumeThread(self):
		while self.decreaseVolume:
			if self.config.volumeControl == 'AVR':
				self.avr.volumeDown()
			else:
				self.xbmc.volumeDown()
			sleep(0.1)				

##################################################################################
#
#  Event handlers for Signals
#
##################################################################################
	def volumeUp(self):
		self.increaseVolume = True
		volumeThread = threading.Thread(None, self.increaseVolumeThread)
		volumeThread.start()		

	def volumeUpStop(self):
		self.increaseVolume = False
		
	def volumeDown(self):
		self.decreaseVolume = True
		volumeThread = threading.Thread(None, self.decreaseVolumeThread)
		volumeThread.start()		
					
	def volumeDownStop(self):
		self.decreaseVolume = False				

	def eventFilter(self,object,event):
		if event.type() == QEvent.User+0:
			self.markCurrentSong(event.getCurrentSongIndex())
			return True
		return False

	def click(self):
		try:
			items = self.ui.treeWidget.selectedItems()
			dir = items[0].text(1)
			dirlabel = items[0].text(0)
			removeNext = False
			if self.ui.navLayout.count() == 0:
				rootButton = QPushButton("//")
				rootButton.setCheckable(True)
				self.ui.navLayout.addWidget(rootButton,0)
				rootButton.clicked.connect(self.mapper.map)
				self.mapper.setMapping(rootButton, "//|GOTO_SHARES_ROOT")
	
			if items[0].text(2) == "directories":
				ix = 0
				buttonCount = self.ui.navLayout.count()
				buttons = []
				while ix < buttonCount:
					button = self.ui.navLayout.itemAt(ix).widget()
					if removeNext == True:
						buttons.append(button)		
					if button.isChecked():
						removeNext = True
						button.setChecked(False)
					ix = ix + 1
						
				for but in buttons:
					self.ui.navLayout.removeWidget(but)
					if but is not None:
						but.deleteLater()
	
				dirButton = QPushButton(dirlabel)
				dirButton.setCheckable(True)
				dirButton.setChecked(True)
				dirButton.clicked.connect(self.mapper.map)
				self.mapper.setMapping(dirButton, items[0].text(0) + "|" + items[0].text(1))
				self.ui.navLayout.addWidget(dirButton,0)
				
				self.getDirectory(dir)
			elif items[0].text(2) == "files":
				if items[0].checkState(0) == Qt.Checked:
					items[0].setCheckState(0, Qt.Unchecked)
				elif items[0].checkState(0) == Qt.Unchecked:
					items[0].setCheckState(0, Qt.Checked)
		except:
			print "---"

		
	def navButtonclick(self,label_dir):
		ldlist = label_dir.split("|")
		ix = 0
		buttonCount = self.ui.navLayout.count()	
		while ix < buttonCount:
			button = self.ui.navLayout.itemAt(ix).widget()		
			if ldlist[0] == button.text():
				button.setChecked(True)
			else:
				button.setChecked(False)
			ix = ix + 1
		if ldlist[1] == "GOTO_SHARES_ROOT":
			self.getMusicShareDirectories()
		else:
			self.getDirectory(ldlist[1])

		
	def addSelectedSongs(self):
		#self.ui.statusBar.clearMessage()
		self.ui.treeWidgetPlaylist.setColumnCount(1)
		itemsList = []
		playlist_length = self.ui.treeWidgetPlaylist.topLevelItemCount()
		ic = 0
		while ic < self.ui.treeWidget.topLevelItemCount():
			item = self.ui.treeWidget.topLevelItem(ic)
			if item.text(2) == "files" and item.checkState(0) == Qt.Checked:
				item.setCheckState(0,Qt.Unchecked)
				item1 = QTreeWidgetItem()
				item1.setText(0, item.text(0))
				item1.setText(1, item.text(1))
				item1.setText(2, item.text(2))
				res=self.xbmc.addSong(item.text(1))
				if res.MType == 'S':
					itemsList.append(item1)
				else:
					#self.ui.statusBar.showMessage(res.MText)
					print res.MText
			ic = ic + 1
		ix = playlist_length + 1
		self.ui.treeWidgetPlaylist.insertTopLevelItems(ix, itemsList)
		self.ui.treeWidget.clearSelection()
		self.shuffle()
		self.currentSongIx = -1
		

	def addAllSongs(self):
		#self.ui.statusBar.clearMessage()
		self.ui.treeWidgetPlaylist.setColumnCount(1)
		itemsList = []
		playlist_length = self.ui.treeWidgetPlaylist.topLevelItemCount()
		ic = 0
		while ic < self.ui.treeWidget.topLevelItemCount():
			item = self.ui.treeWidget.topLevelItem(ic)
			if item.text(2) == "files":
				item.setCheckState(0,Qt.Unchecked)
				item1 = QTreeWidgetItem()
				item1.setText(0, item.text(0))
				item1.setText(1, item.text(1))
				item1.setText(2, item.text(2))
				res=self.xbmc.addSong(item.text(1))
				if res.MType == 'S':
					itemsList.append(item1)
				else:
					#self.ui.statusBar.showMessage(res.MText)
					print res.MText
			ic = ic + 1
		ix = playlist_length + 1
		self.ui.treeWidgetPlaylist.insertTopLevelItems(ix, itemsList)
		self.ui.treeWidget.clearSelection()
		self.shuffle()
		self.currentSongIx = -1

	def clearPlaylist(self):
		#self.ui.statusBar.clearMessage()
		res = self.xbmc.clearPlaylist()
		if res.MType != 'S':
			#self.ui.statusBar.showMessage(res.MText)
			print res.MText
		self.ui.treeWidgetPlaylist.clear()
		self.getCurrentPlaylistItems()					
					
	def playSongs(self):
		#self.ui.statusBar.clearMessage()
		stopped = self.setPlayButtonState()
		if stopped:
			res = self.xbmc.play()
		else:
			res = self.xbmc.pause()
		if res.MType != 'S':
			#self.ui.statusBar.showMessage(res.MText)
			print res.MText
		self.setPlayButtonState()
			
	def stopPlaying(self):
		#self.ui.statusBar.clearMessage()
		res = self.xbmc.stop()
		if res.MType != 'S':
			#self.ui.statusBar.showMessage(res.MText)
			print res.MText
		self.setPlayButtonState()	
					

	def skipNext(self):
		#self.ui.statusBar.clearMessage()
		res = self.xbmc.skipNext()
		if res.MType != 'S':
			#self.ui.statusBar.showMessage(res.MText)
			print res.MText
		self.setPlayButtonState()			

	def skipPrevious(self):
		#self.ui.statusBar.clearMessage()
		res = self.xbmc.skipPrevious()
		if res.MType != 'S':
			#self.ui.statusBar.showMessage(res.MText)
			print res.MText
		self.setPlayButtonState()
			
	def shuffle(self):
		#self.ui.statusBar.clearMessage()
		if self.ui.pushButtonShuffle.isChecked():
			res = self.xbmc.shuffle()			
		else:
			res = self.xbmc.unShuffle()
		if res.MType != 'S':
			#self.ui.statusBar.showMessage(res.MText)
			print res.MText
		self.ui.treeWidgetPlaylist.clear()
		self.getCurrentPlaylistItems()	
		
	def toggleFullScreen(self):
		if self.fullScreen:
			self.fullScreen = False			
			self.showNormal()
		else:
			self.fullScreen = True					
			self.showFullScreen()	
			
	def showToolsDialog(self):
		toolsDialog = tools_dialog.XPotToolsDialog(self)
		toolsDialog.ui.labelNameVersion.setText( "%s %s" % (self.name, self.version) )
		toolsDialog.ui.labelDeveloper.setText( "by %s" % self.developer )
		toolsDialog.ui.labelEmail.setText( self.email )
		a = toolsDialog.exec_()
		if a == 1:
			self.config = toolsDialog.config
			toolsDialog.updateConfig()
			self.xbmc.setConnectionParameters(self.config.server, self.config.port, self.config.user, self.config.password)

