import Qt 4.7
import QtMobility.sensors 1.1

Rectangle {
    id: main
    width: 800
    height: 480
    x:0
    y:0
    color:"white"

    property int screenWidth: 800;
    property int screenHeight: 480;

    Behavior on rotation { RotationAnimation { direction: RotationAnimation.Shortest; duration: 500; easing.type: Easing.OutBounce } }

    OrientationSensor {
        id : orientation
        active: true

        onReadingChanged: {
            if ( reading.orientation == OrientationReading.TopUp ) {
                main.rotation = 0;
                main.width = screenWidth;
                main.height =  screenHeight;
                main.x=0;
                main.y=0;//0;
                // state= 'TopUp';
                /*
                cntlogo.x=(top.width/2)-(351/2);
                cntlogo.y=(top.height/2)-(46/2);
                */
            } else if ( reading.orientation == OrientationReading.TopDown ) {
                main.rotation=180;
                main.width = screenWidth;
                main.height = screenHeight;
                main.x=0;
                main.y=0;//state='TopDown';
                /*
                cntlogo.x=(top.width/2)-(351/2);
                cntlogo.y=(top.height/2)-(46/2);
                */
            } else if ( reading.orientation == OrientationReading.LeftUp ) {
                main.rotation=270;//state='LeftUp';
                main.width = screenHeight;
                main.height = screenWidth;
                main.x = ((800 - 480) / 2);
                main.y= -((800 - 480) / 2);
                /*
                cntlogo.x=0;
                cntlogo.x=0;
                */
            } else if ( reading.orientation == OrientationReading.RightUp ) {
                main.rotation=90;
                main.x = (800 - 480) / 2;
                main.y= -(800 - 480) / 2;
                main.width = 480;
                main.height = 800;
                /*
                cntlogo.x=0;
                cntlogo.x=0;
                */
            }
        }
    }

    ListModel {
        id: theModel;
    }
    Image {
        id: loading
        width: 72
        height: 74
        x: (main.width/2)-(width/2);
        y: (main.height/2)-(height/2);

        NumberAnimation on rotation {
            running: loading.opacity > 0; from: 0; to: 360; loops: Animation.Infinite; duration: 1500
        }

    }

    ListView {
        id: liview
        orientation: ListView.Vertical
        width: main.width
        height:main.height-250
        x:0
        y:200
        visible: false


        delegate: Column {
            Text { x:20; font.family: "Verdana"; font.pixelSize: 18; font.bold:  true; text: title; }

            Flickable {
                id: flickable
                height: he
                width: main.width
                contentWidth: contentItem.childrenRect.width
                contentHeight: contentItem.childrenRect.height
                clip: true
                flickableDirection: Flickable.HorizontalFlick



                Image {
                    id: shwimg
                    x:10;
                    asynchronous: true;
                    width: wi
                    height: he
                    source: img;

                }

            }
        }
    }


    Rectangle {
        id: inputrect
        y: 55;//100
        width: main.width
        height: 100

		ShadowRectangle {
			height: 50
			width: (main.width/2)
			x: (inputrect.width/2)-(width/2)
			y: (inputrect.height/2)-25
        	        color: "white"



        TextInput {
            id: theinput
            height: 50
            text: "your input"
            cursorVisible: true
            font.bold: true
            font.pointSize: 30
            smooth: true
            horizontalAlignment: TextInput.AlignHCenter
//            x: (inputrect.width/2)-(width/2)
            width: (main.width/2)
  //          y: (inputrect.height/2)-25
            //onFocusChanged: ( text == "your input" ) ? text='';


            Image {
                id: equalimg
                x:(theinput.width+30)
                y:(theinput.height/2)-7
                source: "equal.png"
                scale: 4.0

                MouseArea {
                    anchors.fill: parent
                    onClicked: start_searching()
                }
            }
        }
        }
	//}

    }

    function start_searching()
    {
	loading.source = 'computing3.gif';
        xmlmodel.source='';
        imgsmodel.source='';
        xmlmodel.reload();
        imgsmodel.reload();
        liview.model = '';
        liview.visible = false;
        if ( theinput.text.length > 0 )
        {
            console.log("seearching for " + theinput.text);
            console.log("url = http://api.wolframalpha.com/v2/query?input="+encodeURI(theinput.text.toString()) + "&appid=" + theapi + "&format=image");
            xmlmodel.source = "http://api.wolframalpha.com/v2/query?input="+theinput.text.toString() + "&appid=" + theapi + "&format=image";
//            xmlmodel/
        }
    }

    Rectangle {
        id: top
        width: main.width
        height: 50//100
        color: "lightgray"
        radius: 7
        border.color: "#000000"

        Rectangle {
            id: tr
            x: main.width-100;
            width: 100
            height:50
            color: "transparent"

            Image {
                id: imx
                height: 48
                width: 48
                x: (tr.width/2)-24
                y: (tr.height/2)-24
                source: "/usr/share/icons/hicolor/48x48/hildon/general_close.png"

            }

            MouseArea {
                width:  100
                height:  50;//100
                onPressed: imx.scale=1.9;
                onPressAndHold: imx.scale=1.9;
                onReleased: imx.scale=1;
                onClicked: Qt.quit();
            }
        }
        Image {
            id: cntlogo
	    width: 160
	    height: 27
            x: (top.width/2)-(width/2)
            y: (top.height/2)-(height/2)
            source: "logo.png"

        }
    }

    XmlListModel {
        id: imgsmodel
        query: "/queryresult/pod/subpod/img"

        XmlRole { name: "img"; query: "attribute(src)/string()" }
        XmlRole { name: "wi"; query: "attribute(width)/string()" }
        XmlRole { name: "he"; query: "attribute(height)/string()" }

        onStatusChanged: {
            if (status == XmlListModel.Ready && source != "" )
                buildinfo();


        }
    }

    XmlListModel {
        id: xmlmodel
        objectName : "xmlmodel"

        //source: srcurl
        query: "/queryresult/pod"

        XmlRole { name: "title"; query: "attribute(title)/string()" }
        XmlRole { name: "np"; query: "attribute(numsubpods)/string()" }

        onStatusChanged: {
            if ( status == XmlListModel.Loading ) {
                liview.visible=true;
//                loading.source = "computing3.gif";
            } else if (status == XmlListModel.Ready && source != "" ){
                console.log("fetched : " + xmlmodel.count);
        //        loading.source='';
                imgsmodel.source = xmlmodel.source;

            }
        }

    }

    function buildinfo()
    {
        if ( theModel.count > 0 )
            theModel.clear();


        var title = xmlmodel.get(0).title;
        console.log("title@0 = " + title.toString());
        console.log("numpods for 0 =  " + xmlmodel.get(0).np.toString());
        console.log("img@0 = " + imgsmodel.get(0).img.toString());
        var limit = parseInt(xmlmodel.count);
        var cimg = 0;
        for ( var i = 0; i < limit; i++ )
        {
            var np = parseInt(xmlmodel.get(i).np);
            if ( np == 1 ) {
                console.log("title = " + xmlmodel.get(i).title.toString() + " img = " + imgsmodel.get(cimg).img.toString());
                //fruitModel.append({"cost": 5.95, "name":"Pizza"})
                theModel.append({"title": xmlmodel.get(i).title.toString(), "img": imgsmodel.get(cimg).img.toString(), "wi": imgsmodel.get(cimg).wi, "he" : imgsmodel.get(cimg).he });
                cimg++;
            } else {
                cimg++;
                console.log("title = " + xmlmodel.get(i).title.toString() + " img = " + imgsmodel.get(cimg).img.toString());
                theModel.append({"title": xmlmodel.get(i).title.toString(), "img": imgsmodel.get(cimg).img.toString(), "wi": imgsmodel.get(cimg).wi, "he" : imgsmodel.get(cimg).he });
                for ( var y=1; y < np; y++ )
                {
                    console.log("title = vacante  img = " + imgsmodel.get(cimg).img.toString());
                    theModel.append({"title": "", "img": imgsmodel.get(cimg).img.toString(), "wi": imgsmodel.get(cimg).wi, "he" : imgsmodel.get(cimg).he });
                    cimg++;
                }
            }
        }
	loading.source = '';
        liview.model = theModel;
        liview.visible = true;
    }
}
