#account class representing all the objects
#for access to an account and associated runtime tweets/etc

import twitter
import oauthtwitter
import gtk
import re
import osso
import hildon
import urllib2
import urllib
import simplejson
import bitly
import accountData

class account():


    #these are the keys for witter on twitter
    CONSUMER_KEY = 'c0glxehHLYgzDqDMLjanA'
    CONSUMER_SECRET = 'V37SuM6o7PddlqqosLpYtIqyaLj0mgnFkGGKkJjN6I'
    ACTIVE = 1
    INACTIVE = 2
    status = ""

    def __init__(self, osso_c, accData):
        #these store all the data associated with this accounts tweets
        # the fields are : Name,nameColour,Tweet,TweetColour,id, type, timestamp, replyTo, source
        self.tweetstore = gtk.ListStore(str, str, str, str, str, str, str, str, str)
        #then we want the same again to store dm's, mentions & pubilc timeline separately
        self.dmstore = gtk.ListStore(str, str, str, str, str, str, str, str, str)
        self.mentionstore = gtk.ListStore(str, str, str, str, str, str, str, str, str)
        self.publicstore = gtk.ListStore(str, str, str, str, str, str, str, str, str)
        self.trendstore = gtk.ListStore(str, str, str, str, str, str, str, str, str)
        self.friendsstore = gtk.ListStore(str, str, str, str, str, str, str, str, str)
        self.searchstore = gtk.ListStore(str, str, str, str, str, str, str, str, str)
        self.userhistorystore = gtk.ListStore(str, str, str, str, str, str, str, str, str)
        #base url can be set to any twitter compatible site, so we can support mutliple account types
        self.accountdata = accData
        self.osso_c = osso_c
        self.api = None
        if accData.password:
            self.api = twitter.Api(username=accData.username, password=accData.password)
            self.api.SetBaseUrl(accData.baseUrl)
            self.api.SetBaseSearchUrl(accData.searchUrl)
        if (accData.access_token != None):
            self.api = oauthtwitter.OAuthApi(self.CONSUMER_KEY, self.CONSUMER_SECRET, accData.access_token)



    def getAccountData(self):
        return self.accountdata

    def getAccountType(self):
        return self.accountdata.accessType

    def getUsername(self):
        return self.accountdata.username

    def getPassword(self):
        return self.accountdata.password

    def getServicename(self):
        return self.accountdata.servicename

    def getBaseUrl(self):
        return self.accountdata.baseUrl

    def setBaseUrl(self, url):
        self.accountdata.baseUrl = url

    def setSearchUrl(self, url):
        self.accountdata.searchUrl = url
    def getSearchUrl(self):
        return self.accountdata.searchUrl
    def getAccessToken(self):
        return self.accountdata.access_token

    def setStatus(self, status):
        self.accountdata.status = status

    def setBitlyCreds(self, username, apikey):
        self.accountdata.bitlyusername = username
        self.accountdata.bitlyapikey = apikey

    def setServiceCreds(self, username, password=None, access_token=None):
        self.accountdata.username = username
        if password:
            self.accountdata.password = password
            self.accountdata.accessType = "Basic"
            self.api = twitter.Api(username=self.accountdata.username, password=self.accountdata.password)
            #override the base url for a basic auth account, allows us to use non-twitter accounts
            self.api.SetBaseUrl(self.accountdata.baseUrl)
        if access_token:
            self.accountdata.access_token = access_token
            self.accountdata.accessType = "OAuth"
            self.api = oauthtwitter.OAuthApi(self.CONSUMER_KEY, self.CONSUMER_SECRET, self.accountdata.access_token)
            self.api.SetBaseUrl(self.accountdata.baseUrl)

    #accessor methods that return the entire list of data
    #stores for this account under the different types
    def getTimeline(self):
        return self.tweetstore

    def getDmsList(self):
        return self.dmstore
    def getMentionsList(self):
        return self.mentionstore
    def getPublicList(self):
        return self.publicstore
    def getFriendsList(self):
        return self.friendsstore
    def getSearchList(self):
        return self.searchstore
    def getTrendsList(self):
        return self.trendstore
    def getUserHistoryList(self):
        return self.userhistorystore

    def getTweets(self, auto=0, older=False, get_count=20, * args):
        if (self.api == None):
            print "account not configured"
            return
        print "getting tweets with " + self.accountdata.username
        print "base url = " + self.accountdata.baseUrl
        print "base url of api object = " + self.api.GetBaseUrl()
        receive_count = 0
        try:
            #by default we get newer tweets
            if (older == False):
                if self.accountdata.last_id == None:
                    data = self.api.GetFriendsTimeline()
                else:
                    print "refreshing since" + str(self.accountdata.last_id)
                    data = self.api.GetFriendsTimeline(since_id=self.accountdata.last_id)
            else:
                if self.accountdata.oldest_id == None:
                    data = self.api.GetFriendsTimeline(count=get_count)
                else:
                    print "refreshing prior to" + str(self.accountdata.oldest_id)
                    data = self.api.GetFriendsTimeline(max_id=self.accountdata.oldest_id, count=get_count)

            for x in data:
                 if (self.accountdata.last_id != None):
                    if (x.id == self.accountdata.last_id):
                        continue
                 if (None != x.in_reply_to_status_id):
                    print "reply to " + x.in_reply_to_screen_name
                    #we don't want anything showing up if there is no reply_to, so all teh formatting is held here including the newline
                    reply_to = "In reply to: " + x.in_reply_to_screen_name + " - " + self.get_specific_tweet(x.in_reply_to_screen_name, x.in_reply_to_status_id)
                 else:
                    reply_to = ""

                 reply_to = reply_to.replace("&", "&amp;")
                 #need to store id numbers for oldest/newest
                 if self.accountdata.last_id == None:
                    self.accountdata.last_id = x.id
                 else:
                    #if we have an id stored, check if this one is 'newer' if so then store it
                    if long(self.accountdata.last_id) < long(x.id):
                        self.accountdata.last_id = x.id

                 #also want to track the oldest we get hold of
                 if self.accountdata.oldest_id == None:
                    self.accountdata.oldest_id = x.id
                 else:
                    if long(self.accountdata.oldest_id) > long(x.id):
                        self.accountdata.oldest_id = x.id
                 #strip the source app name from the url
                 source = self.getSourceAppname(x.source)
                 text = self.escapeText(x.text)
                 text = self.expandBitlyUrls(text)
                 self.tweetstore.append([ "@" + x.user.screen_name, "", "@" + x.user.screen_name + " : " + text, "", x.id, "Tweet", x.created_at, reply_to, source])
                 receive_count = receive_count + 1

            if (receive_count > 0):
                note = osso.SystemNote(self.osso_c)
                result = note.system_note_infoprint(str(receive_count) + " Tweets Received")

        except IOError, e:
            print "error"
            msg = 'Error retrieving tweets '
            if hasattr(e, 'reason'):
                msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
                    reason = "Service unavailable"
                else:
                    reason = ""
                msg = msg + 'Server returned ' + str(e.code) + " : " + reason
            if (auto == 0):
                note = osso.SystemNote(self.osso_c)
                note.system_note_dialog(msg)
            print msg



    def getMentions(self, auto=0, older=False, get_count=20, * args):
        if (self.api == None):
            print "account not configured"
            return
        print "getting mentions"
        receive_count = 0
        try:
            #by default we get newer tweets
            if (older == False):
                if self.accountdata.last_mention_id == None:
                    data = self.api.GetReplies()
                else:
                    print "refreshing since" + str(self.accountdata.last_mention_id)
                    data = self.api.GetReplies(since_id=self.accountdata.last_mention_id)
            else:
                if self.accountdata.oldest_mention_id == None:
                    data = self.api.GetReplies(count=get_count)
                else:
                    print "refreshing prior to" + str(self.accountdata.oldest_mention_id)
                    data = self.api.GetReplies(max_id=self.accountdata.oldest_mention_id, count=get_count)

            for x in data:
                 if (self.accountdata.last_mention_id != None):
                    if (x.id == self.accountdata.last_mention_id):
                        continue
                 if (None != x.in_reply_to_status_id):
                    print "reply to " + x.in_reply_to_screen_name
                    #we don't want anything showing up if there is no reply_to, so all teh formatting is held here including the newline
                    reply_to = "In reply to: " + x.in_reply_to_screen_name + " - " + self.get_specific_tweet(x.in_reply_to_screen_name, x.in_reply_to_status_id)
                 else:
                    reply_to = ""

                 reply_to = reply_to.replace("&", "&amp;")
                 #need to store id numbers for oldest/newest
                 if self.accountdata.last_mention_id == None:
                    self.accountdata.last_mention_id = x.id
                 else:
                    #if we have an id stored, check if this one is 'newer' if so then store it
                    if long(self.accountdata.last_mention_id) < long(x.id):
                        self.accountdata.last_mention_id = x.id

                 #also want to track the oldest we get hold of
                 if self.accountdata.oldest_mention_id == None:
                    self.accountdata.oldest_mention_id = x.id
                 else:
                    if long(self.accountdata.oldest_mention_id) > long(x.id):
                        self.accountdata.oldest_mention_id = x.id
                 #strip the source app name from the url
                 source = self.getSourceAppname(x.source)
                 text = self.escapeText(x.text)
                 text = self.expandBitlyUrls(text)
                 self.mentionstore.append([ "@" + x.user.screen_name, "", "@" + x.user.screen_name + " : " + text, "", x.id, "Tweet", x.created_at, reply_to, source])
                 receive_count = receive_count + 1

            if (receive_count > 0):
                note = osso.SystemNote(self.osso_c)
                result = note.system_note_infoprint(str(receive_count) + " Mentions Received")

        except IOError, e:
            print "error"
            msg = 'Error retrieving mentions '
            if hasattr(e, 'reason'):
                msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
                    reason = "Service unavailable"
                else:
                    reason = ""
                msg = msg + 'Server returned ' + str(e.code) + " : " + reason
            if (auto == 0):
                note = osso.SystemNote(self.osso_c)
                note.system_note_dialog(msg)
            print msg

    def getDMs(self, auto=0, older=False, get_count=20, * args):
        if (self.api == None):
            print "account not configured"
            return
        print "getting dms"
        receive_count = 0
        try:
            #by default we get newer tweets
            if (older == False):
                if self.accountdata.last_dm_id == None:
                    data = self.api.GetDirectMessages()
                else:
                    print "refreshing since" + str(self.accountdata.last_mention_id)
                    data = self.api.GetDirectMessages(since_id=self.accountdata.last_dm_id)
            else:
                if self.accountdata.oldest_dm_id == None:
                    data = self.api.GetDirectMessages(count=get_count)
                else:
                    print "refreshing prior to" + str(self.accountdata.oldest_dm_id)
                    data = self.api.GetDirectMessages(max_id=self.accountdata.oldest_dm_id, count=get_count)

            for x in data:
                 if (self.accountdata.last_dm_id != None):
                    if (x.id == self.accountdata.last_dm_id):
                        continue

                 #need to store id numbers for oldest/newest
                 if self.accountdata.last_dm_id == None:
                    self.accountdata.last_dm_id = x.id
                 else:
                    #if we have an id stored, check if this one is 'newer' if so then store it
                    if long(self.accountdata.last_dm_id) < long(x.id):
                        self.accountdata.last_dm_id = x.id

                 #also want to track the oldest we get hold of
                 if self.accountdata.oldest_dm_id == None:
                    self.accountdata.oldest_dm_id = x.id
                 else:
                    if long(self.accountdata.oldest_dm_id) > long(x.id):
                        self.accountdata.oldest_dm_id = x.id
                 user = x.GetSenderScreenName()
                 text = self.escapeText(x.text)
                 text = self.expandBitlyUrls(text)
                 self.dmstore.append([ "@" + user, "", "@" + user + " : " + text, "", x.id, "Tweet", x.created_at, "", ""])
                 receive_count = receive_count + 1

            if (receive_count > 0):
                note = osso.SystemNote(self.osso_c)
                result = note.system_note_infoprint(str(receive_count) + " DMs Received")

        except IOError, e:
            print "error"
            msg = 'Error retrieving dms '
            if hasattr(e, 'reason'):
                msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
                    reason = "Service unavailable"
                else:
                    reason = ""
                msg = msg + 'Server returned ' + str(e.code) + " : " + reason
            if (auto == 0):
                note = osso.SystemNote(self.osso_c)
                note.system_note_dialog(msg)
            print msg

    def getFriends(self, auto=0, older=False, get_count=20, * args):
        if (self.api == None):
            print "account not configured"
            return
        print "getting Friends"
        receive_count = 0
        self.friendsstore.clear()
        try:
            #by default we get newer tweets
            data = self.api.GetFriends()

            if (data != None):
                for x in data:
                    #it's possible to follow someone that has never updated their status
                    if (x.status != None):
                        status = x.status.text
                        tweettime = x.status.created_at
                        source = x.status.source
                    else:
                        status = ""
                        tweettime = ""
                        status = ""
                    status = self.escapeText(status)
                    self.friendsstore.append([ "@" + x.screen_name, "", "@" + x.screen_name + " : " + status, "", x.id, "friend", tweettime, "", source])
                    receive_count = receive_count + 1

                if (receive_count > 0):
                    note = osso.SystemNote(self.osso_c)
                    result = note.system_note_infoprint(str(receive_count) + " Friends Received")

        except IOError, e:
            print "error"
            msg = 'Error retrieving friends '
            if hasattr(e, 'reason'):
                msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
                    reason = "Service unavailable"
                else:
                    reason = ""
                msg = msg + 'Server returned ' + str(e.code) + " : " + reason
            if (auto == 0):
                note = osso.SystemNote(self.osso_c)
                note.system_note_dialog(msg)
            print msg

    def getPublic(self, auto=0, older=False, get_count=20, * args):
        if (self.api == None):
            print "account not configured"
            return
        print "getting public"
        receive_count = 0
        try:
            #by default we get newer tweets
            if (older == False):
                if self.accountdata.last_public_id == None:
                    data = self.api.GetPublicTimeline()
                else:
                    print "refreshing since" + str(self.accountdata.last_public_id)
                    data = self.api.GetPublicTimeline(since_id=self.accountdata.last_public_id)
            else:
                if self.accountdata.oldest_public_id == None:
                    data = self.api.GetPublicTimeline(count=get_count)
                else:
                    print "refreshing prior to" + str(self.accountdata.oldest_public_id)
                    data = self.api.GetPublicTimeline(max_id=self.accountdata.oldest_public_id, count=get_count)

            for x in data:
                 if (self.accountdata.last_public_id != None):
                    if (x.id == self.accountdata.last_public_id):
                        continue
                 if (None != x.in_reply_to_status_id):
                    print "reply to " + x.in_reply_to_screen_name
                    #we don't want anything showing up if there is no reply_to, so all teh formatting is held here including the newline
                    reply_to = "In reply to: " + x.in_reply_to_screen_name + " - " + self.get_specific_tweet(x.in_reply_to_screen_name, x.in_reply_to_status_id)
                 else:
                    reply_to = ""

                 reply_to = reply_to.replace("&", "&amp;")
                 #need to store id numbers for oldest/newest
                 if self.accountdata.last_public_id == None:
                    self.accountdata.last_public_id = x.id
                 else:
                    #if we have an id stored, check if this one is 'newer' if so then store it
                    if long(self.accountdata.last_public_id) < long(x.id):
                        self.accountdata.last_public_id = x.id

                 #also want to track the oldest we get hold of
                 if self.accountdata.oldest_public_id == None:
                    self.accountdata.oldest_public_id = x.id
                 else:
                    if long(self.accountdata.oldest_public_id) > long(x.id):
                        self.accountdata.oldest_public_id = x.id
                 #strip the source app name from the url
                 source = self.getSourceAppname(x.source)
                 text = self.escapeText(x.text)
                 text = self.expandBitlyUrls(text)
                 self.publicstore.append([ "@" + x.user.screen_name, "", "@" + x.user.screen_name + " : " + text, "", x.id, "Tweet", x.created_at, reply_to, source])
                 receive_count = receive_count + 1

            if (receive_count > 0):
                note = osso.SystemNote(self.osso_c)
                result = note.system_note_infoprint(str(receive_count) + " public timeline Received")

        except IOError, e:
            print "error"
            msg = 'Error retrieving public timeline '
            if hasattr(e, 'reason'):
                msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
                    reason = "Service unavailable"
                else:
                    reason = ""
                msg = msg + 'Server returned ' + str(e.code) + " : " + reason
            if (auto == 0):
                note = osso.SystemNote(self.osso_c)
                note.system_note_dialog(msg)
            print msg

    def getUserHistory(self, friend="", auto=0, older=False, get_count=20, * args):
        if (self.api == None):
            print "account not configured"
            return
        print "getting User history for " + friend
        self.userhistorystore.clear()
        receive_count = 0
        try:
            #by default we get newer tweets
            data = self.api.GetUserTimeline(id=friend)

            for x in data:

                 if (None != x.in_reply_to_status_id):
                    print "reply to " + x.in_reply_to_screen_name
                    #we don't want anything showing up if there is no reply_to, so all teh formatting is held here including the newline
                    reply_to = "In reply to: " + x.in_reply_to_screen_name + " - " + self.get_specific_tweet(x.in_reply_to_screen_name, x.in_reply_to_status_id)
                 else:
                    reply_to = ""

                 reply_to = reply_to.replace("&", "&amp;")

                 #strip the source app name from the url
                 source = self.getSourceAppname(x.source)
                 text = self.escapeText(x.text)
                 text = self.expandBitlyUrls(text)
                 self.userhistorystore.append([ "@" + x.user.screen_name, "", "@" + x.user.screen_name + " : " + text, "", x.id, "Tweet", x.created_at, reply_to, source])
                 receive_count = receive_count + 1

            if (receive_count > 0):
                note = osso.SystemNote(self.osso_c)
                result = note.system_note_infoprint(str(receive_count) + " user timeline Received")

        except IOError, e:
            print "error"
            msg = 'Error retrieving user timeline '
            if hasattr(e, 'reason'):
                msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
                    reason = "Service unavailable"
                else:
                    reason = ""
                msg = msg + 'Server returned ' + str(e.code) + " : " + reason
            if (auto == 0):
                note = osso.SystemNote(self.osso_c)
                note.system_note_dialog(msg)
            print msg

    def getSearch(self, searchTerms="", auto=0, older=False, get_count=20, * args):
        print "performing search"
        self.searchstore.clear()
        receive_count = 0

        if (searchTerms == ""):
            print "nothing to search"
            return
        #split the tweet text on any comma , 

        searchTermsList = searchTerms.split(",")
        #call search on each of the terms in the search str
        for term in searchTermsList:
            term = unicode(term).encode('utf-8')
            #then we need to urlencode so that we can use twitter chars like @ without
            #causing problems
            search = urllib.urlencode({ 'q' : term })

            try:
                print "search url " + self.accountdata.searchUrl + 'search.json?' + search
                json = urllib2.urlopen(self.accountdata.searchUrl + 'search.json?' + search)

                #JSON is awesome stuff. we get given a long string of json encoded information
                #which contains all the tweets, with lots of info, we decode to a json object
                data = simplejson.loads(json.read())
                #then this line does all the hard work. Basicaly for evey top level object in the JSON
                #structure we call out getStatus method with the contents of the USER structure
                #and the values of top level values text/id/created_at

                results = data['results']
                for x in results:
                    reply_to = ""
                    reply_to = reply_to.replace("&", "&amp;")
                    text = self.escapeText(x['text'])
                    text = self.expandBitlyUrls(text)
                    #strip the source app name from the url
                    source = self.getSourceAppname(x['source'])
                    self.searchstore.append([ "@" + x['from_user'], "", "@" + x['from_user'] + " : " + text, "", x['id'], "Search", x['created_at'], reply_to, source])
                    receive_count = receive_count + 1
                    note = osso.SystemNote(self.osso_c)
                    result = note.system_note_infoprint("Search results Received for : " + term)
            except IOError, e:
                msg = 'Error retrieving search results '
                if hasattr(e, 'reason'):
                    msg = msg + str(e.reason)

                if hasattr(e, 'code'):
                    if (e.code == 401):
                        reason = "Not authorised: check uid/pwd"
                    elif(e.code == 503):
                        reason = "Service unavailable"
                    else:
                        reason = ""
                    msg = msg + 'Server returned ' + str(e.code) + " : " + reason
                if (auto == 0):
                    note = osso.SystemNote(self.osso_c)
                    note.system_note_dialog(msg)
    def getTrends(self, *args):

        print "getting Trending topics"
        #first clear the previous 10
        self.trendstore.clear()

        try:
            json = urllib2.urlopen(self.accountdata.searchUrl + 'trends.json')
            #JSON is awesome stuff. we get given a long string of json encoded information
            #which contains all the tweets, with lots of info, we decode to a json object
            data = simplejson.loads(json.read())
            #then this line does all the hard work. Basicaly for evey top level object in the JSON
            #structure we call out getStatus method with the contents of the USER structure
            #and the values of top level values text/id/created_at
            trends = data['trends']
            for x in trends:
                self.trendstore.append([x['name'], "", x['name'] + " :" + x['url'], "", "", "dm", "", "", ""])

            note = osso.SystemNote(self.osso_c)

            result = note.system_note_infoprint("Trends Received")
        except IOError, e:
            msg = 'Error retrieving trends '
            if hasattr(e, 'reason'):
               msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
                    reason = "Service unavailable"
                else:
                    reason = ""
                msg = msg + 'Server returned ' + str(e.code) + " : " + reason
                note = osso.SystemNote(self.osso_c)
                note.system_note_dialog(msg)


    def get_specific_tweet(self, screen_name, tweet_id):
        try:
            data = self.api.GetStatus(tweet_id)
            return data.text
        except IOError, e:
            print e
            return "protected tweet"

    def getSourceAppname(self, sourceUrl):
         #need to strip the source name from the html we get given
         if (re.search("</a>", sourceUrl)):
            startChar = sourceUrl.find(">")
            endChar = sourceUrl.find("</a>")
            sourceUrl = sourceUrl[startChar + 1:endChar]
         if (re.search("&lt;/a&gt;", sourceUrl)):
            startChar = sourceUrl.find("&gt;")
            endChar = sourceUrl.find("&lt;/a&gt;")
            sourceUrl = sourceUrl[startChar + 4:endChar]
         return sourceUrl

    def newTweet(self, tweet, reply_to_name=None, reply_to_id=None):
        #The other main need of a twitter client
        #the ability to post an update
        #get the tweet text from the input box

        #see if we have just an empty string (eg eroneous button press)
        if (tweet == ""):
            return

        try:

            if (reply_to_name != None):
                if (re.search(reply_to_name, tweet)):
                    #this is a reply
                    status = self.api.PostUpdate(tweet, reply_to_id)
                else:
                    status = self.api.PostUpdate(tweet)
            else:
                status = self.api.PostUpdate(tweet)

            return True
        except IOError, e:
            msg = 'Error posting tweet '
            if hasattr(e, 'reason'):
                msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                    if (e.code == 401):
                        reason = "Not authorised: check uid/pwd"
                    elif(e.code == 503):
                        reason = "Service unavailable"
                    else:
                        reason = ""
                    msg = msg + 'Server returned ' + str(e.code) + " : " + reason

            note = hildon.hildon_note_new_information(self.window, msg)
            note.run()
            note.destroy()
            return False

    def FollowUser(name):
        #strip out the @ which isn't really part of the username
        name = name.replace("@", "")
        print "follow: " + name
        try:
                print "using oauth to follow"
                data = self.api.CreateFriendship(name)
                note = osso.SystemNote(self.osso_c)
                result = note.system_note_infoprint("Now following " + name)
        except IOError, e:
            print "error"
            msg = 'Error following ' + name + ' '
            if hasattr(e, 'reason'):
                msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
                    reason = "Service unavailable"
                else:
                    reason = ""
                msg = msg + 'Server returned ' + str(e.code) + " : " + reason

            note = osso.SystemNote(self.osso_c)
            note.system_note_dialog(msg)
            print msg

    def UnFollowUser(name):
        #strip out the @ which isn't really part of the username
        name = name.replace("@", "")
        print "follow: " + name
        try:
                print "using oauth to unfollow"
                data = self.api.DestroyFriendship(name)
                note = osso.SystemNote(self.osso_c)
                result = note.system_note_infoprint("Now following " + name)
        except IOError, e:
            print "error"
            msg = 'Error unfollowing ' + name + ' '
            if hasattr(e, 'reason'):
                msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
                    reason = "Service unavailable"
                else:
                    reason = ""
                msg = msg + 'Server returned ' + str(e.code) + " : " + reason

            note = osso.SystemNote(self.osso_c)
            note.system_note_dialog(msg)
            print msg

    def escapeText(self, text):
        #switch certain chars for escape sequences
        text = text.replace("&", "&amp;")
        return text

    def expandBitlyUrls(self, data):

        if (self.accountdata.bitlyusername != ""):
                words = data.split(" ")
                for word in words:
                    if re.search("http://bit.ly", word):
                        #appears to have a bitly URL so lets lengthen it
                        try:
                            bitlyapi = bitly.Api(login=self.accountdata.bitlyusername, apikey=self.accountdata.bitlyapikey)

                            longurl = bitlyapi.expand(word)
                            #having gotten the long url
                            #strip out the domain name and append it to the tweet
                            #after the bit.ly url in brackets
                            enddomain = int(longurl.find("/", 7, len(longurl)))
                            print enddomain
                            longurl = longurl[7:enddomain]

                            #switch the long url in to the data


                            data = data.replace(word, word + " (" + longurl + ")")
                        except bitly.BitlyError:
                            print "bitly gave error response"
                        except KeyError:
                            print "bitly gave key error response"
        return data
