from gnome import gconf
from wifi_assistant.settings.network_settings import NetworkSettings
from wifi_assistant.settings.network_setting import NetworkSetting

import unittest

class NetworkSettingsTest(unittest.TestCase):

    def setUp(self):
        self.gc = gconf.client_get_default()
        self.root = '/apps/maemo/wifi/unit_tests'
        self._clearGConf(self.root)
        self._setupDefaultValues(self.root)
        self.testee = NetworkSettings(self.gc, self.root)
    
        
    def _setupDefaultValues(self, dir):
        #settings = NetworkSetting()
        #settings.setBrowserOption("url", "http://wifi-assistant.wendt.se/")
        #settings.setNameOfBrowserToLaunch("default")
        #settings.setNetworkName("default_settings")
        #self.testee.save(settings)
        #self.gc.set_string(dir + '/default_settings/options/url', 'http://wifi-assistant.wendt.se/')
        #self.gc.set_string(dir + '/default_settings/browser', 'default')
        # moved this into code for now
        return
    
        
    def _clearGConf(self, dir):
        # there's no recursive_unset available
        all_entries = self.gc.all_entries(dir)
        for entry in all_entries:
            self.gc.unset(entry.get_key())
        for sub_dir in self.gc.all_dirs(dir):
            self._clearGConf(sub_dir)
        self.gc.suggest_sync()
        
        

    def _createSettings(self, ssid):
        return NetworkSetting({'name':ssid})


    def test_an_unkown_ssid_returns_None(self):
        settings = self.testee.get('unknown')
        assert settings is None
        
    
    def test_saving_works(self):
        ssid = 'test'
        settings = self._createSettings(ssid)
        
         # make sure it's empty first
        assert self.testee.get(ssid) is None
        
        self.testee.save(settings)
        assert self.testee.get(ssid) is not None
        
        
    def test_removing_network_setting_works(self):
        ssid = 'test'
        settings = self._createSettings(ssid)
        
         # make sure it's empty first
        assert self.testee.get(ssid) is None
        
        self.testee.save(settings)
        assert self.testee.get(ssid) is not None

        self.testee.delete(settings)
        value =  self.testee.get(ssid)
        assert value is None
        
    
    def test_network_name_can_contain_space_dash_and_underscore(self):
        ssid = 'This Is-My_Network'
        settings = self._createSettings(ssid)
        
         # make sure it's empty first
        assert self.testee.get(ssid) is None
        
        self.testee.save(settings)
        value = self.testee.get(ssid)
        assert value is not None
        assert value.getNetworkName() == ssid
        
        
    def test_default_settings(self):
        defaults = self.testee.getDefaultSettings()
        assert defaults.getNameOfBrowserToLaunch() == 'default'
        browser_options = defaults.getBrowserOptions()
        assert defaults.getLaunchingOfBrowserEnabled() is True
        assert browser_options is not None
        assert browser_options.has_key('url')
        assert "http://" in browser_options['url']
        
        
    def test_list(self):
        ssid = 'This Is-My_Network'
        settings = self._createSettings(ssid)
        self.testee.save(settings)
        
        store = self.testee.getListStore()
        assert store is not None
        store_len = len(store)
        assert store_len == 1


    def test_adding_same_network_twice_joins_and_overwrites_settings(self):
        pass
        # FIXME: the list store needs update instead of append etc


if __name__ == '__main__':
    unittest.main()

