#!/usr/bin/python2.5
import gtk, hildon

def _(str):
    return str

class ApplicationSettingsDialog():
    
    CANCEL_BUTTON = 1
    SAVE_BUTTON = 2
    
    def __init__(self, parent_window, saveCallback):
        """saveCallback(popup, url)"""
        
        self._parent_window = parent_window
        self._saveCallback = saveCallback


    def show(self, use_popup, url_to_open):
        checkbox = hildon.CheckButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        checkbox.set_label(_('Show popup when connected to a new SSID'))
        checkbox.set_active(use_popup)
        
        url_label = gtk.Label(_('URL to open when launching browser:')) # IMPROVEMENT: caption?
        url_label.set_alignment(0, 0.5)
        url_label.set_padding(5, 5)
        url_field = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        url_field.set_text(url_to_open)
        
        dialog = gtk.Dialog(_('Settings'), self._parent_window)
        dialog.vbox.set_homogeneous(False)
        
        dialog.vbox.add(checkbox)
        dialog.vbox.add(url_label)
        dialog.vbox.add(url_field)
        
        dialog.add_button(_('Cancel'), ApplicationSettingsDialog.CANCEL_BUTTON)
        dialog.add_button(_('Save'), ApplicationSettingsDialog.SAVE_BUTTON)
        
        dialog.show_all()
        result = self._runDialog(dialog)
        dialog.hide()
        
        if result == ApplicationSettingsDialog.SAVE_BUTTON:
            self._saveCallback(checkbox.get_active(), url_field.get_text())


    def _runDialog(self, dialog):
        result = dialog.run()
        return result
