from wifi_assistant.gui.network_settings_view import NetworkSettingsView
import gtk

import unittest
from unit.pie import *

class NetworkSettingsViewTest(unittest.TestCase):

    def setUp(self):
        self._list_store = gtk.ListStore('gboolean', str)
        self._parent_container = Mock()
        self._edit_callback = Mock()
        
        given(self._edit_callback).save().willReturn(True)
        
        self.testee = NetworkSettingsView(self._list_store, self._parent_container, self._edit_callback.save)


    def test_bug_11209_addingAndRemovingNetworkSettingsChangesActiveWidget(self):
        assert len(self._list_store) == 0
        
        self._replayMocks()
        self._list_store.append([True, 'a row'])
        
        widget = self.testee._active_widget
        verify(self._parent_container).add(widget)
        
        self._list_store.clear()
        
        verify(self._parent_container).remove(widget)
        
        
    def _replayMocks(self):
        self._parent_container.replay()
        self._edit_callback.replay()

        
    
if __name__ == '__main__':
    unittest.main()
