from gnome import gconf
from wifi_assistant.gui.about_dialog import AboutDialog

import unittest
from unit.pie import *

class AboutDialogTest(unittest.TestCase):

    def setUp(self):
        self.launcher = Mock()
        self.launcher.replay()
        self.testee = AboutDialog(self.launcher, None)


    def test_bugButtonCallsLauncher(self):
        self._makeRunDialogReturn(AboutDialog.BUG_BUTTON)
        self.testee.show()
        verify(self.launcher).openUrl(AboutDialog.BUG_URL)


    def test_closeButtonDoesntCallLauncher(self):
        self._makeRunDialogReturn(AboutDialog.CLOSE_BUTTON)
        self.testee.show()
        verify(self.launcher, never()).openUrl()


    def test_donateButtonCallsLauncher(self):
        self._makeRunDialogReturn(AboutDialog.DONATE_BUTTON)
        self.testee.show()
        verify(self.launcher).openUrl(AboutDialog.DONATE_URL)
        

    def test_bug_11199_dialogTitleContainsVersion(self):
        class checkVersionOnShow():
            def __init__(self, version):
                self.version = version
            def __call__(self, dialog):
                assert self.version in dialog.get_title()
        
        self.testee._runDialog = checkVersionOnShow(AboutDialog.VERSION)
        self.testee.show()


    def _makeRunDialogReturn(self, value):
        class method():
            def __init__(self, testee, value_to_return):
                self._value_to_return = value_to_return
                self._testee= testee
            
            def __call__(self, dialog):
                self._testee._responseCallback(dialog, self._value_to_return)

        self.testee._runDialog = method(self.testee, value)
        
    
if __name__ == '__main__':
    unittest.main()
