#!/usr/bin/python2.5
import gtk, hildon

def _(str):
    return str

class EditNetworkDialog():
    
    NO_BUTTON = gtk.RESPONSE_NO
    YES_BUTTON = gtk.RESPONSE_YES
    
    def __init__(self, parent_window, saveCallback):
        """saveCallback(iter, ssid, launch_browser)"""
        
        self._parent_window = parent_window
        self._saveCallback = saveCallback


    def show(self, iter, ssid):
        dialog = gtk.Dialog(ssid, self._parent_window)
        dialog.vbox.set_homogeneous(False)
        
        dialog.add_button(_('No'), EditNetworkDialog.NO_BUTTON)
        dialog.add_button(_('Yes'), EditNetworkDialog.YES_BUTTON)
        
        label = gtk.Label(_('After being connected to ' + ssid + ' do you wish to launch a browser?')) #FIXME: l10n
        label.set_line_wrap(True)
        label.set_justify(gtk.JUSTIFY_LEFT)
        label.set_alignment(0, 0.5)
        dialog.vbox.add(label)
    
        dialog.show_all()
        result = self._runDialog(dialog)
        dialog.hide()
        
        launch_browser = None
        if result ==  EditNetworkDialog.YES_BUTTON:
            launch_browser = True
        elif result == EditNetworkDialog.NO_BUTTON:
            launch_browser = False
        
        if launch_browser is not None:
            self._saveCallback(iter, ssid, launch_browser)
    

    def _runDialog(self, dialog):
        result = dialog.run()
        return result
