#!/usr/bin/python2.5
import gtk, hildon
import conic
import gobject
import logging

from launcher import Launcher

def _(str):
    return str

log = logging.getLogger("wfdaemon")

class Daemon():
    
    def __init__(self, launcher, application_settings, network_settings, parent_window):
        self._application_settings = application_settings
        self._network_settings = network_settings
        self._parent = parent_window
        self._launcher = launcher
        self._popup = self._application_settings.getUsePopup()
        log.debug("_popup(%s)", self._popup)


    def connectionEstablished(self, ssid):
        log.debug("connectionEstablished(%s)", ssid)
        settings = self._network_settings.get(ssid)
        if settings is None:
            if self.showDecisionDialog(ssid):
                defaults = self._network_settings.getDefaultSettings()
                self.launchBrowser(defaults)
            return
    
        if settings.getLaunchingOfBrowserEnabled():
            self.launchBrowser(settings)
    

    def launchBrowser(self, settings):
        log.debug("launchBrowser(%s)", settings)
        browser_name = settings.getNameOfBrowserToLaunch()
        browser_options = settings.getBrowserOptions()
        if 'url' in browser_options:
            self._launcher.launchBrowser(browser_name, browser_options)
        # the following line is the backwards compatible line
        else:
            settings = self._network_settings.getDefaultSettings()
            self.launchBrowser(settings)
    
    def showDecisionDialog(self, ssid):
        log.debug("showDecisionDialog(%s)", ssid)
        if not self._popup:
            return False
        
        from wifi_assistant.gui.popup_dialog import PopupDialog
        PopupDialog(self._parent, self._showDecisionDialogCallback).show(ssid)
        
    def _showDecisionDialogCallback(self, ssid, launch_browser, remember):        
        log.debug("_showDecisionDialogCallback(%s, %s, %s)", ssid, launch_browser, remember)
        setting = self._network_settings.getDefaultSettings()
        setting.setNetworkName(ssid)
        setting.setLaunchingOfBrowserEnabled(launch_browser)
        
        if remember:
            self._network_settings.save(setting)
        
        if launch_browser:
            self.launchBrowser(setting)
    
    
    def start(self):
        log.debug("start")
        self._connection = conic.Connection()
        self._connection.connect("connection-event", self._connectionEventCallback)
        self._connection.set_property("automatic-connection-events", True)
        self._application_settings.registerUsePopupListener(self._usePopupEventCallback)
        self._startLoop()
        
     
    def stop(self):
        log.debug("stop")
        self._application_settings.unregisterUsePopupListener(self._usePopupEventCallback)
        self._connection.set_property("automatic-connection-events", False)
        
    
    def _connectionEventCallback(self, connection, event):
        log.debug("_connectionEventCallback(%s)", event)
        status = event.get_status()
        if status == conic.STATUS_CONNECTED:
            # assemble id > name dict
            iap_id_to_name = {}
            iaps = connection.get_all_iaps()
            for iap in iaps:
                iap_id = iap.get_id()
                iap_name = iap.get_name()
                iap_id_to_name[iap_id] = iap_name
            
            # get name of network
            iap_id = event.get_iap_id()
            iap_name = None
            if (iap_id_to_name.has_key(iap_id)):
                iap_name = iap_id_to_name[iap_id]
            self.connectionEstablished(iap_name)
    

    def _usePopupEventCallback(self, gconfClient, id, gconfEntry, x):
        log.debug("_usePopupEventCallback(%s)", gconfEntry)
        self._popup = gconfEntry.get_value().get_bool()


    def _startLoop(self):
            gtk.main()
