/****************************************************************************
**
** Copyright (C) 2010 Jussi Vatjus-Anttila
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
****************************************************************************/
#include "widget.h"

//#include <QtSvg/QSvgRenderer>
//#include <QMovie>
//#include <libnotify/notify.h>

#include <QtDBus>
#include <QPainter>
#include <QPaintEvent>
#include <QPen>
#include <QBrush>
#include <QPushButton>
#include <QTimer>
#include <QInputDialog>
#include <QFileDialog>
#include <QLineEdit>
#include <QtNetwork>
#include <QNetworkAccessManager>
#include <QFile>
#include <QVBoxLayout>
#include <QMap>
#include <QSettings>
#include <QSlider>
#include <QTime>
#include <QDate>
#include <QFont>

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <QtGui/QX11Info>
#include <QtCore/QByteArray>
#include <QtCore/QCoreApplication>

#include <QtGui/QMessageBox>

#include "settingsdialog.h"


Widget::Widget()
    : QWidget(0, Qt::FramelessWindowHint),
      dirty(true)
{
    //To optimize painting a bit you can set the following:
    //   note that child widgets might not be composed
    //   correctly then though
    //setAttribute(Qt::WA_PaintOnScreen);
    //setAttribute(Qt::WA_NoSystemBackground);

    const char name[] = "Qt sample notification app";
   
    QCoreApplication::instance()->setApplicationName(name);

    /* Init libnotify library */


    // Get required atoms
    Atom winTypeAtom = XInternAtom(QX11Info::display(), "_NET_WM_WINDOW_TYPE", false);
    Atom homeAppletAto = XInternAtom(QX11Info::display(), "_HILDON_WM_WINDOW_TYPE_HOME_APPLET", false);
    Atom appletIDAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_ID", false);
    Atom utf8Atom = XInternAtom(QX11Info::display(), "UTF8_STRING", false); 
    Atom appletSettingAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SETTINGS", false);
   
    // Set correct window type
    XChangeProperty(QX11Info::display(), winId(), winTypeAtom, XA_ATOM, 32,
		    PropModeReplace, (unsigned char *) &homeAppletAto, 1);

    // Use application name to fill AppletID
    QByteArray id (QCoreApplication::instance()->applicationName().remove(' ').toUtf8());
    XChangeProperty(QX11Info::display(), winId(), appletIDAtom, utf8Atom, 8, 
    	            PropModeReplace, (unsigned char *)id.constData(), id.length());

    // Add setting button. This button is shown when hildon-desktop is in edit mode. 
    int settings = 0;
    XChangeProperty(QX11Info::display(), winId(), appletSettingAtom, XA_CARDINAL, 32,
		    PropModeReplace, (unsigned char*)&settings, 1);
    
    runButton = new QPushButton(tr("enable"));
    runButton->setCheckable(true);
    runButton->setChecked(false);
    runButton->setFixedSize(90, 50);
    runButton->setFont( QFont( "lucida", 14, QFont::Bold, FALSE ) );
    runButton->setStyleSheet("border-width: 1px;border-style: outset;border-radius: 14px;  border-color: #0c457e; color: black;");


    nextButton = new QPushButton(tr("next"));
    nextButton->setFixedSize(90, 50);
    nextButton->setFont( QFont( "lucida", 14, QFont::Bold, FALSE ) );
    nextButton->setStyleSheet("border-width: 1px;border-style: outset;border-radius: 14px;  border-color: #0c457e; color: black;");

    prevButton = new QPushButton(tr("prev"));
    prevButton->setFixedSize(90, 50);
    prevButton->setFont( QFont( "lucida", 14, QFont::Bold, FALSE ) );
    prevButton->setStyleSheet("border-width: 1px;border-style: outset;border-radius: 14px;  border-color: #0c457e; color: black;");

    /*
    progressSlider = new QSlider( Qt::Vertical );
    progressSlider->setRange(0, 100);
    progressSlider->setValue(0);
    progressSlider->setStyleSheet( "background-color: blue; border-color: magenta;border-style: solid; border-width: 1px; width: 3px;" );
    */

    connect(runButton, SIGNAL(toggled(bool)), this, SLOT(activateConnection(bool)));
    connect(prevButton, SIGNAL(pressed()), this, SLOT(prevCamera()));
    connect(nextButton, SIGNAL(pressed()), this, SLOT(nextCamera()));


    timer = new QTimer( this );
    connect( timer, SIGNAL(timeout()), SLOT(timerHandler()) );

    timerInfo = new QTimer(this);
    timerInfo->setSingleShot(true);
    connect( timerInfo, SIGNAL(timeout()), SLOT(timerInfoHandler()) );
    timerInfo->start(m_showInfoTimeout = 4000);
    m_showInfo = true;

    m_cameraChangedWhenLoadingProcess = false;

    //renderer = new QSvgRenderer(QLatin1String("hummingbird.svg"), this);///usr/share/applications/qtexample-hildondesktopwidget/

    QHBoxLayout *layout = new QHBoxLayout;
    layout->addWidget(runButton);
    layout->addWidget(prevButton);
    layout->addWidget(nextButton);
    /*QHBoxLayout *test = new QHBoxLayout;
    test->addWidget( progressSlider );
    test->addSpacing( 350 );*/

    QVBoxLayout *mainLayout = new QVBoxLayout;
    mainLayout->addSpacing(260);
    //mainLayout->addLayout(test);
    mainLayout->addLayout(layout);
    setLayout(mainLayout);


    m_networkmanager = new QNetworkAccessManager(this);
    connect(m_networkmanager, SIGNAL(finished(QNetworkReply*)), this,
                              SLOT(replyFinished(QNetworkReply*)));
    /*connect(m_networkmanager, SIGNAL(proxyAuthenticationRequired(QNetworkProxy,QAuthenticator*)), this,
                              SLOT(replyAuthenticationRequired(QNetworkProxy, QAuthenticator*)));
    connect(m_networkmanager, SIGNAL(sslErrors(QNetworkReply*,QList<QSslError>)), this,
                              SLOT(replySslError(QNetworkReply*,QList<QSslError>)));
    connect(m_networkmanager, SIGNAL(authenticationRequired(QNetworkReply*,QAuthenticator*)), this,
                              SLOT(replyauthenticationRequired(QNetworkReply*,QAuthenticator*)));*/

    m_refreshInterval = 1; //10 * 100ms
    m_loadingInProcess = false;

    QCoreApplication::setOrganizationName("JuPe");
    QCoreApplication::setOrganizationDomain("http://webcamviewer.garage.maemo.org");
    QCoreApplication::setApplicationName("Webcam Viewer");
    this->setWindowTitle("Webcam Viewer");

    m_settings = new QSettings("Webcamviewer", "webcamviewer");


    //m_settings->clear();

    int size = m_settings->beginReadArray("cams");
    for (int i = 0; i < size; ++i) {
         m_settings->setArrayIndex(i);
         Cam_s cam( m_settings->value("nick").toString(),
                    m_settings->value("address").toString(),
                    m_settings->value("username").toString(),
                    m_settings->value("password").toString(),
                    m_settings->value("updateIntervall").toInt(),
                    m_settings->value("updateWhenClicked").toBool(),
                    QByteArray::fromBase64( m_settings->value("lastImage").toByteArray())
                    );
         m_camList.append(cam);
     }
     m_settings->endArray();

     if( m_camList.size() == 0)
     {
         m_camList.append( Cam_s( tr("Oulu - Tuiran sillat"),    tr("http://www.oulunkaupunki.fi/_private/kamera/image20.jpg") ));
         m_camList.append( Cam_s( tr("Oulu - Rajakylän puisto"), tr("http://www.oulunkaupunki.fi/siltaweb/silta.jpg") ));
         m_camList.append( Cam_s( tr("Oulu - Nallikari"),        tr("http://weathercam.vaisala.net/banner/weather.aspx?id=nallikari") ) );
     }

     //Current camera index from list
     m_currentCamIndex = m_settings->value("current", 0).toInt();
     m_pImageData = m_currentCamIndex==-1? 0 : &(m_camList.at(m_currentCamIndex).lastImage);
}


Widget::~Widget()
{
    m_settings->beginWriteArray("cams");
    for (int i = 0; i < m_camList.size(); ++i) {
        m_settings->setArrayIndex(i);
        m_settings->setValue("nick", m_camList.at(i).nick);
        m_settings->setValue("address", m_camList.at(i).address);
        m_settings->setValue("username", m_camList.at(i).username);
        m_settings->setValue("password", m_camList.at(i).username);
        m_settings->setValue("updateIntervall", m_camList.at(i).updateIntervall);
        m_settings->setValue("lastImage", m_camList.at(i).lastImage.toBase64() );
        m_settings->setValue("updateWhenClicked", m_camList.at(i).updateWhenClicked);
    }
    m_settings->endArray();
    m_settings->setValue(tr("current"), m_currentCamIndex);
    m_settings->sync();
    delete m_settings;

}
/**
    Activate connection.
    -start timer
    -refresh labels
    Nothing else
 */
void Widget::activateConnection(bool toggle)
{
    refreshLabels(toggle);
    if(toggle)
    {
        timer->start( m_camList.at(m_currentCamIndex).updateIntervall*100 );
        //runButton->setStyleSheet("border-width: 1px;border-style: outset;border-radius: 14px;  border-color: #0c457e;");

        showInformationNote("Connection enabled");

        update();


    }
    else
    {
        //runButton->setStyleSheet("border-width: 1px;border-style: outset;border-radius: 14px;  background-color: white;");
        timer->stop();
        showInformationNote("Connection disabled");
        update();

        /*
        NotifyNotification *notification;

        // Create notification
        notification = notify_notification_new(name,
            "Just want you to know...", NULL, NULL);
        if (notification) {
            // Set timeout
            notify_notification_set_timeout(notification, 3000);
            // Schedule notification for showing
            if (!notify_notification_show(notification, NULL))
                qDebug("Failed to send notification");

            // Clean up the memory
            g_object_unref(notification);
        } else
            qDebug("Failed to create notification");
        */
    }
}
/**
  Refresh label by connection status
  */
void Widget::refreshLabels(bool online)
{
    if(online)
    {
        runButton->setText("disable");
    }
    else
    {
        runButton->setText("enable");
    }
}
/**
  Timer handler. When timer occurs event..
  */
void Widget::timerHandler()
{
    //Be sure that there's no previous download processes.
    if(!m_loadingInProcess && m_currentCamIndex>=0 &&
        m_currentCamIndex < m_camList.size() &&
        !m_camList.at(m_currentCamIndex).updateWhenClicked )
    {
        //download image from url
        downloadFile( m_camList.at (m_currentCamIndex).address );
    }
}
/**
    timer handler for  "show cam info"
 */
void Widget::timerInfoHandler()
{
    this->m_showInfo = false;
}


/**
  Download file and repaint it to UI
  */
void Widget::downloadFile(QUrl url)
{
    this->repaint();
    download(url);
    //this->repaint();
}
/** Previous camera to display */
void Widget::prevCamera()
{
    if(m_camList.size()>0){
        if( m_currentCamIndex > 0 ){
            m_currentCamIndex--;
            changeCamera();
        }
    }
}
/** Next camera to display */
void Widget::nextCamera()
{
    if(m_camList.size()>0){
        if( m_currentCamIndex < m_camList.size()-1 ){
            m_currentCamIndex++;
            changeCamera();
        }
    }
}
/** Common tasks when camera is changed */
void Widget::changeCamera()
{


    m_cameraChangedWhenLoadingProcess = this->m_loadingInProcess?true:false;

    timerInfo->start(m_showInfoTimeout);
    m_showInfo=True;

    //Check if current is last camera in list
    if( m_currentCamIndex == m_camList.size()-1 )
    {
        nextButton->setEnabled(false);
        nextButton->setText("");
    }
    else{
        nextButton->setEnabled(true);
        nextButton->setText("next");
    }

    //Check if current is first camera in list
    if( m_currentCamIndex == 0 )
    {
        prevButton->setEnabled(false);
        prevButton->setText("");
    }
    else{
        prevButton->setEnabled(true);
        prevButton->setText("prev");
    }

    /*
    if(!m_loadingInProcess)
        update();*/

    if( m_camList.at(m_currentCamIndex).updateWhenClicked )
    {
        runButton->setEnabled( false );
    }
    else
    {
        runButton->setEnabled( true );
        if( runButton->isChecked() )
            timer->start( m_camList.at(m_currentCamIndex).updateIntervall*100 );
    }


    m_pImageData = &m_camList.at(m_currentCamIndex).lastImage;

    update();

}


/**
  Begin Download url.
  When download is finished
  eventhandler replyFinished() is called
  */
void Widget::download(const QUrl &url)
{
    // this avoid to begin new loading proces
    // while this is finished.
    m_loadingInProcess = true;

    QNetworkReply* reply = m_networkmanager->get(QNetworkRequest(QUrl(url)));
    m_networkReplyList.append( reply );

    connect(reply, SIGNAL(error(QNetworkReply::NetworkError)),
            this, SLOT(replyError(QNetworkReply::NetworkError)));
    connect(reply, SIGNAL(downloadProgress(qint64,qint64)), this,
            SLOT(downloadProgress(qint64, qint64)));
}
void Widget::replyFinished(QNetworkReply* reply)
{
    if( m_networkReplyList.contains( reply ) )
    {
        m_networkReplyList.pop_back();
        //m_pImageData = reply->readAll();
        if(!m_cameraChangedWhenLoadingProcess)
        {
            Cam_s *cam =  (Cam_s*)&m_camList.at(m_currentCamIndex);
            cam->lastImage = reply->readAll();
        }
        else m_cameraChangedWhenLoadingProcess=false;
    }
    m_loadingInProcess = false;
    reply->deleteLater();
    update();
}

void Widget::replyError(QNetworkReply::NetworkError replyError)
{
    m_networkReplyList.pop_back();
    m_loadingInProcess = false;
}

void Widget::downloadProgress(qint64 bytesRead,qint64 totalBytes)
{
    //progressSlider->setValue( bytesRead / totalBytes * 100 );
}
/**
  Paint event (QWidget)
  */
void Widget::paintEvent(QPaintEvent *e)
{

   QPixmap pixmap;
   bool ok=false;
   QPainter pPainter(this);

   if(m_pImageData)
        if(pixmap.loadFromData(*m_pImageData))
             ok = true;


   if(ok)
   {
        pPainter.setBackgroundMode(Qt::TransparentMode);
        pPainter.setClipRect(e->rect());
        pPainter.drawPixmap(rect(), pixmap);


        //below is something code temporary,
        //if can render betterways....or transparent..

        /*
        this->setFixedSize(pixmap.width(),pixmap.height());

        QPainter pPainter(this);
        pPainter.setRenderHint(QPainter::Antialiasing);
        pPainter.setClipRect(e->rect());

        pPainter.save();
        pPainter.setCompositionMode(QPainter::CompositionMode_Source);
        pPainter.fillRect(rect(), Qt::transparent);
        pPainter.restore();

        if (dirty) {
            cache.fill(Qt::transparent);
            QPainter pPainter(&cache);
            p.setRenderHint(QPainter::Antialiasing);
            renderer->render(&pPainter);
            pPainter.end();
            dirty = false;
        }
        p.drawPixmap(0, 0, cache);*/
        //pPainter->drawPixmap(rect(), pixmap);

    }
   else if( m_loadingInProcess)
   {
        //if(pixmap.load(tr("webcamviewer.png")))
        //if(ok);
        pPainter.drawText( QPoint(100,140), tr("Fetching image..."));
   }

    if(m_showInfo)
    {
        pPainter.drawText( QPoint(80,40), m_camList.at(m_currentCamIndex).nick );
    }

    if( timer->isActive() )
    {
        pPainter.setBrush( Qt::red );
        pPainter.setBackgroundMode( Qt::OpaqueMode );
        pPainter.drawEllipse(370, 10, 7, 7);
    }

//    QPainter p(this);
//    p.setRenderHint(QPainter::Antialiasing);
//    p.setClipRect(e->rect());
//
//    //make sure you clean your widget with a transparent
//    //  color before doing any rendering
//    //  note the usage of a composition mode Source
//    //  it's important!
//    p.save();
//    p.setCompositionMode(QPainter::CompositionMode_Source);
//    p.fillRect(rect(), Qt::transparent);
//    p.restore();
//
//    if (dirty) {
//        cache.fill(Qt::transparent);
//        QPainter p(&cache);
//        p.setRenderHint(QPainter::Antialiasing);
//        renderer->render(&p);
//        p.end();
//        dirty = false;
//    }
//    p.drawPixmap(0, 0, cache);
        
}

/** If double clicked -> save webcam shot */
void Widget::mouseDoubleClickEvent( QMouseEvent * event )
{
    if( m_pImageData )
    {
        QString text;
        QDate date = QDate::currentDate();
        QTime time = QTime::currentTime();

        QString defaultName = tr("/home/user/MyDocs/DCIM/webcamviewer_");
        defaultName.append( m_camList.at(m_currentCamIndex).nick.simplified() );
        defaultName.append( tr("_") );
        defaultName.append( date.toString(tr("yyMMdd-")) );
        defaultName.append( time.toString(tr("hhmmss")) );
        defaultName.append( tr(".jpg") );
        text = QFileDialog::getSaveFileName(this, tr("Select file name to save"), defaultName, tr("Images (*.jpg *.png)") );
        if(!text.isEmpty())
        {
            QFile File(text);
            if (!File.open(QIODevice::WriteOnly)) {
                QMessageBox::information(this, "Error", "fail to open file to write");
                return;
            }
            File.write(*m_pImageData);
            File.close();
        }
    }
}
/** If clicked & updateWhenClick enabled -> update cam */
void Widget::mousePressEvent( QMouseEvent * event )
{
    if(!m_loadingInProcess && m_currentCamIndex>=0 &&
        m_currentCamIndex < m_camList.size() )
    {
        //download image from url
        downloadFile( m_camList.at (m_currentCamIndex).address );
    }
}
/**

    x11 Event handler.
    Now we want handle event only when
    messagetype is "appletShowSettingAtom"

  */
bool Widget::x11Event ( XEvent * event )
{
  static Atom appletShowSettingAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SHOW_SETTINGS", false);
  static Atom portraitSupport = XInternAtom(QX11Info::display(), "_HILDON_PORTRAIT_MODE_SUPPORT", false);
  static Atom portraitRequest = XInternAtom(QX11Info::display(), "_HILDON_PORTRAIT_MODE_REQUEST", false);



  if (event->xclient.message_type == appletShowSettingAtom )
  {
        activateConnection(false);

        SettingsDialog *settings = new SettingsDialog(&m_camList);
        settings->show();
        /*
         bool ok;
        //Configure download intervall
        int res = QInputDialog::getInteger(this, tr("Webcam Viewer"), tr("Enter Intervall [0.1s]:"), m_refreshInterval, 1, 100, 1, &ok );
        if ( ok )
        {
            m_refreshInterval = res;
            m_settings->setValue( tr("refreshInterval"), m_refreshInterval);
        }
        m_settings->sync();

        changeCamera();
        activateConnection(true);
        */



      return true;
  }
  else if(event->xclient.message_type == portraitSupport)
  {
       return true;
  }
  else if(event->xclient.message_type == portraitRequest)
  {
        //runButton->setFixedSize(100, 80);
        return true;
  }
  return false;
}
/**
  UI resize event.
  */
void Widget::resizeEvent(QResizeEvent *e)
{
    if (e->size() != cache.size()) {
        cache = QPixmap(e->size());
        dirty = true;
        int w = e->size().width();
        int h = e->size().height();
	Q_UNUSED(w);
	Q_UNUSED(h);
    }
}
void Widget::showInformationNote(QString info_type)
{

    //hildon_banner_show_information(NULL, NULL,"hello");
}
void Widget::showAboutNote(QString info_type){
    QString credits = "\n\nCredits:\n\nProgramming: Jussi Vatjus-Anttila\n";

    QDBusMessage msg = QDBusMessage::createMethodCall("org.freedesktop.Notifications",
                                                      "/org/freedesktop/Notifications",
                                                      "org.freedesktop.Notifications",
                                                      "SystemNoteDialog");
    QString text = info_type + credits;

    QList<QVariant> args;
    args.append(text);
    args.append(static_cast<quint32>(0));
    args.append("ok");

    msg.setArguments(args);

    QDBusConnection::systemBus().call(msg);
}
