#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QtGui/QDialog>

#include "widget.h"
class QListWidgetItem;
class QAbstractButton;

namespace Ui {
    class SettingsDialog;
}

class SettingsDialog : public QDialog {
    Q_OBJECT
public:
    SettingsDialog(QList<Cam_s>* pList, QWidget *parent = 0);
    ~SettingsDialog();
protected:
    void changeEvent(QEvent *e);

private:
    Ui::SettingsDialog *m_ui;
    QList<Cam_s> *m_pCamList;
    QListWidgetItem  *currentItem;

    const Cam_s* FindByNick(QString);
    bool FindByNick(QString, int&);


    void saveItems();

private slots:
    void on_checkBox_clicked(bool checked);
    void on_buttonSaveUrl_clicked();
    void on_url_textEdited(QString );
    void on_buttonNew_clicked();
    void on_buttonRemove_clicked();
    void on_horizontalSlider_valueChanged(int value);
    void on_buttonBox_clicked(QAbstractButton* button);
    void on_listWidget_itemPressed(QListWidgetItem* item);
    void on_listWidget_itemDoubleClicked(QListWidgetItem* item);
};

#endif // SETTINGSDIALOG_H
