/****************************************************************************
**
** Copyright (C) 2010 Jussi Vatjus-Anttila
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
****************************************************************************/
#include "widget.h"

#include <QApplication>

#include <X11/extensions/Xrender.h>

int main(int argc, char **argv)
{
    //qWarning("Please make sure you're running a composition manager!");
    bool  argbVisual=false;
    Display *dpy = XOpenDisplay(0); // open default display
    if (!dpy) {
        qWarning("Cannot connect to the X server");
        exit(1);
    }

    int screen = DefaultScreen(dpy);
    Colormap colormap = 0;
    Visual *visual = 0;
    int eventBase, errorBase;

    if (XRenderQueryExtension(dpy, &eventBase, &errorBase)) {
        int nvi;
        XVisualInfo templ;
        templ.screen  = screen;
        templ.depth   = 32;
        templ.c_class = TrueColor;
        XVisualInfo *xvi = XGetVisualInfo(dpy, VisualScreenMask |
                                          VisualDepthMask |
                                          VisualClassMask, &templ, &nvi);
    
        for (int i = 0; i < nvi; ++i) {
            XRenderPictFormat *format = XRenderFindVisualFormat(dpy,
                                                                xvi[i].visual);
            if (format->type == PictTypeDirect && format->direct.alphaMask) {
                visual = xvi[i].visual;
                colormap = XCreateColormap(dpy, RootWindow(dpy, screen),
                                           visual, AllocNone);
                argbVisual=true;
                break;
            }
        }
    }
    if (argbVisual == true) {
        //qWarning("Found ARGB visual. Starting app...");
    }
    else  {
        qWarning("Couldn't find ARGB visual... Exiting.");
    }


    QApplication app(dpy, argc, argv,
                     Qt::HANDLE(visual), Qt::HANDLE(colormap));

    Widget w;
    w.resize(400, 300);
    w.show();


    return app.exec();
}
