/*
 * client.cpp - client class.
 *
 * Copyright (C) 2010 - Aleksandr A. Lomov.
 *
 * Webauth is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Webauth is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Webauth; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */


#ifndef CLIENT_H
#define CLIENT_H


#include <iostream>
#include <QtCore/QStringList>
#include <QtDBus/QtDBus>
#include <QtDBus>


 class Client: public QObject
 {
    Q_OBJECT
    QDBusInterface authInterface;

    public:
        Client(QString clientID);
        ~Client();

        void sendRequest();

        QString clientID;

    signals:
        void message(const QString &result);


    private slots:
        void messageSlot(const QStringList &result);
};


#endif // CLIENT_H
