/*
 * authmanager.h - authentication manager.
 *
 * Copyright (C) 2010 - Aleksandr A. Lomov.
 *
 * Webauth is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Webauth is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Webauth; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */


#ifndef AUTHMANAGER_H
#define AUTHMANAGER_H

#include <QHash>
#include <QObject>
#include <QNetworkProxy>
#include <QUrl>

#include "mainwindow.h"
#include "captchawindow.h"
#include "authwindow.h"
#include "authdbusadaptor.h"

class AuthManager : public QObject
{
    Q_OBJECT
    public:
        explicit AuthManager(QObject *parent = 0);
        virtual ~AuthManager();

        int initDBus(QObject *parent);

    public Q_SLOTS:
        void setProxy(const QString &proxyIP, const QString &proxyPort,
                const QString &username, const QString &password);
        void shutdown();

    private slots:
        void auth(const QString &url);
        void auth(const QString &url, const QStringList &params);
        void windowsClosed(const int windowID);
        void captchaWindowsClosed(const int windowID);
        void authWindowsClosed(const int windowID);
        void captcha(const QString &strBase64, const QString clientID);
        void login(const QString &clientID);

    private:
        int lastWindowsID, lastCaptchaWindowsID, lastLoginWindowsID;
        QHash<int, MainWindow*> windows;
        QHash<int, CaptchaWindow*> captchaWindows;
        QHash<int, AuthWindow*> loginWindows;
        AuthDBusAdaptor *adapter;
        QNetworkProxy proxy;
        bool isProxySet;

};

#endif // AUTHMANAGER_H
