#include <gtk/gtk.h>
#include <QtCore/QString>
#include <QtCore/QStringList>

//#include "qt_c_api.h"
#include "contacts.h"
#include "contactinfo.hpp"

extern "C" {

struct QByteArray* QByteArray_new()
{
  return new QByteArray;
}

struct QByteArray* QByteArray_copy(const struct QByteArray* str)
{
  return new QByteArray(*str);
}

void QByteArray_delete(struct QByteArray* str)
{
  delete str;
}

void QByteArray_setValue(struct QByteArray* str, const gchar* value)
{
  *str = QByteArray(value);
}

const gchar* QByteArray_getValue(const struct QByteArray* str)
{
  return str->constData();
}

struct QString* QString_new()
{
  return new QString();
}

struct QString* QString_copy(const struct QString* str)
{
  return new QString(*str);
}

void QString_delete(struct QString* str)
{
  delete str;
}

void QString_setValue(QString* str, const gchar* value)
{
  *str = QString::fromUtf8(value);
}

const gchar* QString_getValue(const struct QString *str)
{
  return str->toUtf8();
}


struct QByteArray* QString_toUtf8(const struct QString* str)
{
  return new QByteArray(str->toUtf8());
}

void QStringList_append(QStringList *list, const gchar *value)
{
  list->append( QString::fromUtf8(value) );
}

void ContactInfoList_addContact(ContactInfoList* list, const gchar* name, const gchar* number, const gchar* uniqueId)
{
  // Convert types
  QString qnumber = QString::fromUtf8(number);

  // Can we get an international version of the number
  if (!make_number_international(qnumber))
    return;

  // Create a new contact item
  ContactInfo info;
  info.setName( QString::fromUtf8(name) );
  info.setNumber( qnumber );
  info.setUniqueId( QString::fromUtf8(uniqueId) );

  // Append the info to the list
  list->append( info );
}

} // extern "C"
