/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "contacts.h"
#include "mainwindow.hpp"

// Global includes
#include <QtCore/QTranslator>
#include <QtCore/QLocale>
#include <QtCore/QLibraryInfo>
#include <QtGui/QApplication>

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
  // Setup a new application instance
  QApplication app(argc, argv);
  app.setApplicationName( "web2sms" );
  app.setApplicationVersion( "0.1" );

  // Load new translation for Qt (not available on maemo?)
  QTranslator qtTranslator;
  if ( qtTranslator.load("qt_" + QLocale::system().name(), QLibraryInfo::location(QLibraryInfo::TranslationsPath)) )
    app.installTranslator(&qtTranslator);

  // Load a new translation for web2sms
  QTranslator translator;
  if ( translator.load( QString("web2sms_%1").arg(QLocale::system().name()), ":/translations" ) )
    app.installTranslator(&translator);

  // Init the contacts api
  init_contacts();

  MainWindow mainWindow;
#if defined(Q_WS_S60) || defined(Q_WS_MAEMO_5)
  mainWindow.showMaximized();
#else
  mainWindow.show();
#endif

#ifdef QT_NO_OPENSSL
#error We need OpenSSL!
#endif

  // Init the main window
  mainWindow.init();

  // Run the application
  int ret = app.exec();

  deinit_contacts();

  return ret;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
