/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef __web2sms_providerinterface_hpp__
#define __web2sms_providerinterface_hpp__

// Global includes
#include <QtCore/QtPlugin>
#include <QtGui/QPixmap>

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class ProviderInterface : public QObject
{
  Q_OBJECT

public:
  ProviderInterface(QObject* parent = 0)
  : QObject(parent)
  {}

  virtual QString name() const = 0;
  virtual QPixmap pixmap() const = 0;

  virtual bool hasLoginData() const = 0;
  virtual bool isLoggedIn() const = 0;

  /// Get the count of free sms. A return value of -1 means we have no clue yet.
  virtual int freeSMSCount() const = 0;

  virtual bool showAccountSettingsDialog(QWidget* parent) = 0;

  virtual void login() = 0;
  virtual void logout() = 0;

  virtual int sendMessage(const QString& receiver, const QString& text) = 0;

signals:
  void loginReply(bool success);
  void logoutReply(bool success);
  void sendMessageReply(bool success, int messageId);

  void freeSmsCountChanged(int count);

  void error(const QString& message);
};

Q_DECLARE_INTERFACE(ProviderInterface, "org.maemo.garage.web2sms.ProviderInterface/1.0");

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // __web2sms_providerinterface_hpp__
