/* roadmap_time.h - Manage time information & display.
 *
 * LICENSE:
 *
 *   Copyright 2002 Pascal F. Martin
 *
 *   This file is part of RoadMap.
 *
 *   RoadMap is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   RoadMap is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with RoadMap; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INCLUDE__ROADMAP_TIME__H
#define INCLUDE__ROADMAP_TIME__H

#include "roadmap.h"
#include <time.h>

/*
 * struct timeval clone
 */

typedef struct
{
   time_t epoch_sec;
   unsigned long usec; // Micro second fraction
} EpochTimeMicroSec;

char *roadmap_time_get_hours_minutes (time_t gmt);

uint32_t roadmap_time_get_millis(void);

const EpochTimeMicroSec* roadmap_time_get_epoch_us( EpochTimeMicroSec* time_val );

#endif // INCLUDE__ROADMAP_DISPLAY__H
