#!/usr/bib/python

import pygst
pygst.require("0.10")

# BUG FIX: GObject.threads_init() from gi.repository doesn't work with pygst 0.10:
import gobject
gobject.threads_init()

import gst 
import urllib2
import time

class PlaylistParser:

    def get_track_list(self, playlistUrl):
        if playlistUrl.endswith("m3u"):
            if playlistUrl.startswith("http:"):
                numberOfTries = 3
                response = ""
                while numberOfTries > 0:
                    try:
                        response = urllib2.urlopen(playlistUrl)
                        numberOfTries = 0
                    except urllib2.URLError, e:
                        numberOfTries -= 1
                        if numberOfTries == 0:
                            print "ERROR: opening URL " + str(playlistUrl) + " has failed three times."
                            return ""
                        time.sleep(10)
                return self.parse(response)
            else:
                file = open(playlistUrl)
                return self.parse(file)
        
    def parse(self, lines):
        playlist = []
        for line in lines.readlines():
            line = line.strip()
            if line.startswith('#EXTINF:'):
                continue
            elif (len(line) != 0):
                playlist.append(line)
        return playlist

class AudioPlayer:

    def __init__(self):
        self.pipeline = gst.Pipeline("pipeline")
    
    def play_stream(self, stream, volume):
        self.pipeline = gst.parse_launch("souphttpsrc location=" + stream + " ! decodebin ! pulsesink volume=" + str(volume))
        self.pipeline.set_state(gst.STATE_PLAYING)
        bus = self.pipeline.get_bus()
	bus.add_signal_watch()
	bus.connect("message", self.bus_stream)

    def bus_stream(self, bus, message):
        t = message.type
        if t == gst.MESSAGE_ERROR:
            err, debug = message.parse_error()
            if "Resource not found." in str(err):
                self.backup_sound()

    def bus_mp3(self, bus, message):	
        t = message.type
        if t == gst.MESSAGE_EOS: 
            print "End Of Stream"
            self.next_mp3_track()
        elif t == gst.MESSAGE_ERROR:
            err, debug = message.parse_error()
            print "Error: %s" % err, debug	 

    def next_mp3_track(self):
        self.src.set_state(gst.STATE_NULL)
        self.pipeline.set_state(gst.STATE_NULL)
        self.src.unlink(self.mp3parser)
        self.mp3parser.unlink(self.mp3decoder)
        self.mp3decoder.unlink(self.audiosink)
        if self.trackIndex + 1 < len(self.tracks):
            self.trackIndex += 1
        else:
            trackIndex = 0
        self.play_mp3_track()
	
    def play_mp3_list(self, tracks, volume):
        self.pipeline = gst.Pipeline("pipeline")
        self.mp3parser = gst.element_factory_make("mp3parse", "mp3parse")
        self.mp3decoder = gst.element_factory_make("nokiamp3dec", "nokiamp3dec")
        self.audiosink = gst.element_factory_make("pulsesink", "pulsesink")
        self.audiosink.set_property("volume", volume)
        self.pipeline.add(self.mp3parser)
        self.pipeline.add(self.mp3decoder)
        self.pipeline.add(self.audiosink)
        self.tracks = tracks
        self.trackIndex = 0
        self.play_mp3_track()

    def play_mp3_track(self):
        self.src = gst.element_factory_make("filesrc")
        self.src.set_property("location", self.tracks[self.trackIndex])
        self.pipeline.add(self.src)

        self.src.link(self.mp3parser)
        self.mp3parser.link(self.mp3decoder)
        self.mp3decoder.link(self.audiosink)
        
        bus = self.pipeline.get_bus()
	bus.add_signal_watch()
	bus.connect("message", self.bus_mp3)

        self.pipeline.set_state(gst.STATE_PLAYING)

    def stop(self):
        self.pipeline.set_state(gst.STATE_NULL)

    def bus_loop(self, bus, message):
        t = message.type
        if t == gst.MESSAGE_EOS: 
            self.src.set_state(gst.STATE_NULL)
            self.pipeline.set_state(gst.STATE_NULL)
            self.src.unlink(self.mp3parser)
            self.mp3parser.unlink(self.mp3decoder)
            self.mp3decoder.unlink(self.audiosink)
            self.mp3_loop()
        elif t == gst.MESSAGE_ERROR:
            err, debug = message.parse_error()
            print "Error: %s" % err, debug	 

    def mp3_loop(self):
        self.pipeline = gst.Pipeline("pipeline")
        self.mp3parser = gst.element_factory_make("mp3parse", "mp3parse")
        self.mp3decoder = gst.element_factory_make("nokiamp3dec", "nokiamp3dec")
        self.audiosink = gst.element_factory_make("pulsesink", "pulsesink")
        self.audiosink.set_property("volume", self.volume)
        self.pipeline.add(self.mp3parser)
        self.pipeline.add(self.mp3decoder)
        self.pipeline.add(self.audiosink)
        self.src = gst.element_factory_make("filesrc")
        self.src.set_property("location", self.backupSound)
        self.pipeline.add(self.src)

        self.src.link(self.mp3parser)
        self.mp3parser.link(self.mp3decoder)
        self.mp3decoder.link(self.audiosink)
        
        bus = self.pipeline.get_bus()
	bus.add_signal_watch()
	bus.connect("message", self.bus_loop)
        self.pipeline.set_state(gst.STATE_PLAYING)

    def backup_sound(self):
        self.pipeline.set_state(gst.STATE_NULL)
        self.mp3_loop()

    def play(self, soundPath, volume, backupSound):
        self.volume = volume / 100.0
        self.backupSound = backupSound
        if soundPath.endswith("m3u"):
            parser = PlaylistParser()
            list = parser.get_track_list(soundPath)
            if list == "":
                self.backup_sound()
            elif soundPath.startswith("http"):
                self.play_stream(list[0], self.volume)
            else:
                self.play_mp3_list(list, self.volume)
        else:
            if soundPath.startswith("http"):
                self.play_stream(soundPath, self.volume)

