#!/usr/bin/python

from PyQt4 import QtCore, QtGui
from PyQt4.QtGui import QTabWidget, QColor, QPalette, QLabel, QPixmap
from dialog import ConfigDialog
import ConfigParser
import os
import shutil
import wakeupalarm
import datetime
import configuration

class ConfigButton(QLabel):
    def __init__(self, image, parent=None):
        super(ConfigButton, self).__init__(parent)
        self.setPixmap(image)
        self.parent = parent
    def mousePressEvent(self, event):
        self.parent.open_config()

class QuitButton(QLabel):
    def __init__(self, image, parent=None):
        super(QuitButton, self).__init__(parent)
        self.setPixmap(image)
        self.parent = parent
    def mousePressEvent(self, event):
        QtGui.qApp.quit()

class EndAlarmButton(QLabel):
    def __init__(self, image, parent=None):
        super(EndAlarmButton, self).__init__(parent)
        self.parent = parent
    def mousePressEvent(self, event):
        self.parent.alarmManager.stop_alarm()
        self.setVisible(False)   

class MainWindow(QtGui.QWidget):
    configuration = None
    isMoving = False
    screenWidth = 0
    screenHeight = 0
    buttonYPosition = 500
    statusBarHeight = 50
    buttonSpeed = 20
    
    def __init__(self):
        super(MainWindow, self).__init__()
        self.configuration = Configuration()

        from player import AudioPlayer        
        self.audioPlayer = AudioPlayer()

	self.alarmManager = wakeupalarm.AlarmManager(self.audioPlayer, self.configuration)
	self.frame = Frame(self)
        self.loadImages()
        self.setWindowTitle("Wakeupcall")
        
        self.quitButton = QuitButton(QPixmap.fromImage(self.quitImage), self)
        self.quitButton.setGeometry(self.quitImage.rect())
        self.quitButton.setVisible(False)     
 	self.configButton = ConfigButton(QPixmap.fromImage(self.confImage), self)
        self.configButton.setGeometry(self.confImage.rect())
        self.configButton.setVisible(False)   
 
        self.endAlarmButton = EndAlarmButton(None, self)    
        self.endAlarmButton.setGeometry(0, 0, 800, 100)
        self.endAlarmButton.setStyleSheet("background-color: white; color: black; font-size: 30pt;")
        self.endAlarmButton.setVisible(False)   

        screen = QtGui.QDesktopWidget().screenGeometry()
        self.screenWidth = screen.width()
        self.screenHeight = screen.height()
        self.resize(self.screenWidth, self.screenHeight)
        buttonYPosition = self.screenHeight + self.confImage.rect().height()
	buttonRect = self.confImage.rect()
     
        layout = QtGui.QGridLayout(self)
        layout.addWidget(self.frame, 0, 0, 5, 4)
        self.setLayout(layout)
     
        if self.configuration.fullscreen:
            self.showFullScreen()

    def open_config(self):
        dia = ConfigDialog(self)
        dia.exec_()
	self.configuration.write_configuration()
        self.loadImages()
        self.update_gui()
        self.send_out_the_buttons()

    def update_gui(self):
        if self.configuration.fullscreen:
            self.showFullScreen()
        else:
            self.showNormal()

    def paintEvent(self, event):
        super(MainWindow, self).paintEvent(event)

        painter = QtGui.QPainter(self)
        painter.fillRect(0, 0, self.screenWidth, self.screenHeight, QColor("black"))

    def turn_on_screen(self):
        # Bugfix because pyqt on maemo is broken
        import osso
        if self.configuration.screenalwayson or self.alarmManager.alarm != "":
            osso_c = osso.Context("osso_test_device_on", "0.0.1", False)
            device = osso.DeviceState(osso_c)
            device.display_state_on()

    def mouseReleaseEvent(self, event):
        if self.quitButton.isVisible():
            if self.isMoving == False:
                self.isMoving = True
                self.timer = QtCore.QTimer(self)
                self.timer.timeout.connect(self.send_out_the_buttons)
                self.timer.start(100)
        else:
            if self.isMoving == False:
                self.isMoving = True
                self.timer = QtCore.QTimer(self)
                self.timer.timeout.connect(self.send_in_the_buttons)
                self.timer.start(100)

    def send_in_the_buttons(self):
	buttonRect = self.confImage.rect()
        self.quitButton.setVisible(True)
        self.configButton.setVisible(True)
        buttonYPositionMax = self.screenHeight - buttonRect.height() - self.statusBarHeight
        if self.configuration.fullscreen:
            buttonYPositionMax = self.screenHeight - buttonRect.height()
        if self.buttonYPosition >= buttonYPositionMax:
            self.buttonYPosition -= self.buttonSpeed
            self.configButton.move(0 + (buttonRect.width() / 2), self.buttonYPosition)
            self.quitButton.move(self.screenWidth - buttonRect.width() - (buttonRect.width() / 2), self.buttonYPosition)
        else:
            self.isMoving = False
            self.timer.stop()

    def send_out_the_buttons(self):
	buttonRect = self.confImage.rect()
        buttonYPositionMin = self.screenHeight + buttonRect.height() + self.statusBarHeight
        if self.configuration.fullscreen:
            buttonYPositionMin = self.screenHeight + buttonRect.height()
        if self.buttonYPosition <= buttonYPositionMin:
            self.buttonYPosition += self.buttonSpeed
            self.configButton.move(0 + (buttonRect.width() / 2), self.buttonYPosition)
            self.quitButton.move(self.screenWidth - buttonRect.width() - (buttonRect.width() / 2), self.buttonYPosition)
        else:
            self.isMoving = False
            self.quitButton.setVisible(False)
            self.configButton.setVisible(False)
            self.timer.stop()

    def loadImages(self):
        themePath = self.configuration.themepath

	self.stopImage = QtGui.QImage()
	self.stopImage.load(themePath + "/stop.png")
	self.quitImage = QtGui.QImage()
	self.quitImage.load(themePath + "/quit.png")
	self.confImage = QtGui.QImage()
	self.confImage.load(themePath + "/conf.png")
        self.number0 = QtGui.QImage()
        self.number0.load(themePath + "/number0.png")
        self.number1 = QtGui.QImage()
        self.number1.load(themePath + "/number1.png")
        self.number2 = QtGui.QImage()
        self.number2.load(themePath + "/number2.png")
        self.number3 = QtGui.QImage()
        self.number3.load(themePath + "/number3.png")
        self.number4 = QtGui.QImage()
        self.number4.load(themePath + "/number4.png")
        self.number5 = QtGui.QImage() 
        self.number5.load(themePath + "/number5.png")
        self.number6 = QtGui.QImage()
        self.number6.load(themePath + "/number6.png")
        self.number7 = QtGui.QImage()
        self.number7.load(themePath + "/number7.png")
        self.number8 = QtGui.QImage()
        self.number8.load(themePath + "/number8.png")
        self.number9 = QtGui.QImage()
        self.number9.load(themePath + "/number9.png")
        self.dotOn = QtGui.QImage()
        self.dotOn.load(themePath + "/dotOn.png")
        self.dotOff = QtGui.QImage()
        self.dotOff.load(themePath + "/dotOut.png")
        self.alarmOn = QtGui.QImage()
        self.alarmOn.load(themePath + "/alarmon.png")
        self.alarmOff = QtGui.QImage()
        self.alarmOff.load(themePath + "/alarmoff.png")

class Frame(QtGui.QFrame):
    """
    Frame that displays the time
    """
  
    def __init__(self, parent=None):
        super(Frame, self).__init__(parent)
        self.parent = parent

        timer = QtCore.QTimer(self)
        timer.timeout.connect(self.paint)
        timer.start(1000)

        self.paint()
  
    def paint(self):
        self.parent.turn_on_screen()
        self.update()

    def paintEvent(self, event):
        super(Frame, self).paintEvent(event)
        painter = QtGui.QPainter(self)

        painter.fillRect(0, 0, self.parent.screenWidth, self.parent.screenHeight, QColor("black"))

        xStart = 185
        yStart = 125
        if self.parent.configuration.fullscreen:
            yStart += self.parent.statusBarHeight

        time = QtCore.QTime.currentTime()
        text = time.toString('hh:mm:ss')
        if (time.second() % 2) == 0:
            painter.drawImage(xStart+104, yStart+30, self.parent.dotOff)
            painter.drawImage(xStart+260, yStart+30, self.parent.dotOff)
        else:
            painter.drawImage(xStart+104, yStart+30, self.parent.dotOn)
            painter.drawImage(xStart+260, yStart+30, self.parent.dotOn)

        hour0 = text[0:1]
        hour1 = text[1:2]
        minute0 = text[3:4]
        minute1 = text[4:5]
        sec0 = text[6:7]
        sec1 = text[7:8]

        self.paintDigits(painter, xStart + 0,   yStart + 30, hour0)
        self.paintDigits(painter, xStart + 52,  yStart + 30, hour1)
        self.paintDigits(painter, xStart + 156, yStart + 30, minute0)
        self.paintDigits(painter, xStart + 208, yStart + 30, minute1)
        self.paintDigits(painter, xStart + 312, yStart + 30, sec0)
        self.paintDigits(painter, xStart + 364, yStart + 30, sec1)
        
        if self.parent.configuration.showdate:
            today = datetime.datetime.today()
            painter.drawText(420, yStart+130, today.strftime("%A, %d.%m.%y"))

        if not self.parent.alarmManager.alarm == "":
            self.parent.endAlarmButton.setVisible(True)  
            self.parent.endAlarmButton.setText("  Stop Alarm: " + self.parent.alarmManager.alarm)
        else:
            self.parent.endAlarmButton.setVisible(False)

        if len(self.parent.alarmManager.events) > 0:
            painter.drawImage(610, yStart+30, self.parent.alarmOn)
        else:
            painter.drawImage(610, yStart+30, self.parent.alarmOff)

    def paintDigits(self, painter, x, y, value):
        if value == '0':
            painter.drawImage(x, y, self.parent.number0)
        elif value == '1':
            painter.drawImage(x, y, self.parent.number1)
        elif value == '2':
            painter.drawImage(x, y, self.parent.number2)
        elif value == '3':
            painter.drawImage(x, y, self.parent.number3)
        elif value == '4':
            painter.drawImage(x, y, self.parent.number4)
        elif value == '5':
            painter.drawImage(x, y, self.parent.number5)
        elif value == '6':
            painter.drawImage(x, y, self.parent.number6)
        elif value == '7':
            painter.drawImage(x, y, self.parent.number7)
        elif value == '8':
            painter.drawImage(x, y, self.parent.number8)
        elif value == '9':
            painter.drawImage(x, y, self.parent.number9)
        else:
            painter.drawImage(x, y, self.parent.number0)

def main():
    import sys
    app = QtGui.QApplication(sys.argv)
    win = MainWindow()
    win.show()
    sys.exit(app.exec_())

if __name__ == '__main__':
    main()

