#!/usr/bin/python

import simplejson
import os
import threading
import time
import datetime


USER_HOME = os.getenv("HOME")
FILE_PATH = USER_HOME + "/.config/wakeupcall/"

class AlarmThread(threading.Thread):
    def __init__(self, parent):
        super(AlarmThread, self).__init__()
	self.parent = parent
	
    def run(self):
        while True:
	    now = datetime.datetime.now()
            day = now.weekday()
	    date = now.strftime("%Y-%m-%d")
            if self.parent.alarm == "":
	        for event in self.parent.events:
	            if str(day) in self.parent.events[event]["WeekDays"]:
		        if date not in self.parent.events[event]["Last"]:
		            if now.strftime("%H:%M") == self.parent.events[event]["Time"]:
                                self.parent.alarm = event

			        self.parent.audioPlayer.play(self.parent.configuration.get("Settings", "soundPath"))
                                if self.parent.configuration.getboolean("Settings", "autostopalarm"):
                                    import gobject
                                    gobject.timeout_add(60 * 60000, self.parent.stop_alarm)
			        self.parent.events[event]["Last"] = date
            time.sleep(1)
	
class AlarmManager:
    eventFile = FILE_PATH + "/alarms.json"
    events = {}
    alarm = ""

    def __init__(self, audioPlayer, configuration):
        self.audioPlayer = audioPlayer
        self.configuration = configuration
	if os.path.exists(self.eventFile):
	    self.events = self.load_events()	
	self.thread = AlarmThread(self)
	self.thread.start()

    def load_events(self):
        return simplejson.load(open(self.eventFile))

    def save_events(self):
	simplejson.dump(self.events, open(self.eventFile, "w"))

    def add_event(self, name, weekDays, time):
	self.events[name] = { "WeekDays": str(weekDays), "Time": str(time), "Last": "00.00.0000" }
	self.save_events()

    def remove_event(self, name):
	del self.events[name]
	self.save_events()

    def stop_alarm(self):
        self.audioPlayer.stop()
        self.alarm = ""
    
