#import "ESRenderer.h"

#import <OpenGLES/ES2/gl.h>
#import <OpenGLES/ES2/glext.h>

@interface ES2Renderer : NSObject <ESRenderer>
{
@private
    EAGLContext *context;

    // The pixel dimensions of the CAEAGLLayer
    GLint backingWidth;
    GLint backingHeight;

    // The OpenGL ES names for the framebuffer and renderbuffer used to render to this view
    GLuint defaultFramebuffer, colorRenderbuffer;
	
	Rect viewPort;
}

- (void)render;
- (BOOL)resizeFromLayer:(CAEAGLLayer *)layer;

@property(nonatomic, readwrite) Rect viewPort;
@property(nonatomic, readwrite) GLint backingHeight;

@end
