/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of vumeter.
 *
 *  vumeter is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vumeter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with vumeter.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "volumelinechartwidget.h"

void VolumeLineChartWidget::draw (QPainter *painter)
{
    volumeValues.append(currentValue);
    int n;
    while ((n = 2 * volumeValues.size()) > activeArea.width())
        volumeValues.removeFirst();

    QPen pen(defaultColor, 4);

    QList<int>::const_iterator it = volumeValues.constBegin();
    int prev = *it;
    for (int x = activeArea.left() + activeArea.width() - n;
         ++it != volumeValues.constEnd();
         x += 2)
    {
        if (useColoredScale)
        {
            if (prev < lowerThreshold)
                pen.setColor(lowerColor);
            else if (prev < upperThreshold)
                pen.setColor(midColor);
            else
                pen.setColor(upperColor);
        }
        painter->setPen(pen);

        int const val = *it;
        painter->drawLine(x,
                          activeArea.bottom() - activeArea.height() * prev / maximumValue,
                          x + 2,
                          activeArea.bottom() - activeArea.height() * val / maximumValue);
        prev = val;
    }
}

void VolumeLineChartWidget::drawTriggerIndicator (QPainter *painter, int triggerValue)
{
    int const y = activeArea.bottom() - activeArea.height() * triggerValue / maximumValue;
    painter->setPen(QPen(triggerIndicatorColor, 6));
    painter->drawLine(activeArea.left(), y, activeArea.right(), y);
}

void VolumeLineChartWidget::prepareBackground ()
{
    QPainter painter(background);
    initPainter(&painter);

#ifdef Q_WS_MAEMO_5
    painter.fillRect(0, 0, w, h, Qt::white);
#endif

    QFont f = painter.font();
#ifdef Q_WS_MAEMO_5
    int const fontSize = f.pointSize() * (h + 150) / 240;
#else
    int const fontSize = f.pointSize() * (h + 150) / 150;
#endif
    f.setPixelSize(fontSize);
    painter.setFont(f);

    QRectF frame(10, 10, w - (2 * fontSize) - 16, h - 20);
    painter.setPen(thickPen);
    painter.drawRect(frame);

    activeArea.setRect(frame.left(), frame.top(), frame.width(), frame.height());

    int const tag = maximumValue < 60 ? 10 : maximumValue < 150 ? 20 : 50;

    for (int i = 0; i < maximumValue; i += 10)
    {
        int const y = frame.bottom() - frame.height() * i / maximumValue;

        if (i % tag == 0)
        {
            painter.setPen(thickPen);
            painter.drawText(frame.right() + 8,
                             y + 6,
                             QString().setNum(i));
        }
        else
            painter.setPen(thinPen);

        if (i > 0)
            painter.drawLine(frame.left(), y, frame.right(), y);
    }
}

void VolumeLineChartWidget::setScale (int maxValue)
{
    VolumeMeterWidget::setScale(maxValue);
    volumeValues.clear();
}
