/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of vumeter.
 *
 *  vumeter is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vumeter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with vumeter.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "pa_utils.h"

#include <string.h>
#include <pulse/ext-stream-restore.h>
#include <QString>
#include <QStringList>

#if !defined(Q_WS_MAEMO_5) && !defined(Q_WS_MAEMO_6)

static bool finished = false;
static QStringList source_names;

static void get_source_info_list_callback (pa_context *context, const pa_source_info *info, int eol, void *data)
{
    (void) context;
    (void) data;

    if (!eol)
    {
        qDebug("Source: %s Index: %d", info->name, info->index);
        if (strstr(info->name, "source"))
        {
            qDebug("Using %s as source.", info->name);
            source_names.append(QString(info->name));
        }
    }
    else
    {
        finished = true;
        qDebug("Sending signal...");
        pa_threaded_mainloop_signal(threaded_main_loop, 0);
    }
}

const QStringList &get_source_names ()
{
    pa_context_get_source_info_list(context, get_source_info_list_callback, NULL);
    for (finished = false; !finished; )
    {
        pa_threaded_mainloop_lock(threaded_main_loop);
        pa_threaded_mainloop_wait(threaded_main_loop);
        qDebug("Received signal...");
    }
    pa_threaded_mainloop_unlock(threaded_main_loop);
    return source_names;
}

#endif // !defined(Q_WS_MAEMO_5) && !defined(Q_WS_MAEMO_6)
