/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of vumeter.
 *
 *  vumeter is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vumeter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with vumeter.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "horizontalvolumebarwidget.h"

void HorizontalVolumeBarWidget::draw (QPainter *painter)
{
    int value = std::min(currentValue, lowerThreshold);
    int limit = activeArea.width() * value / maximumValue;

    QRect bar(activeArea.left(),
              activeArea.top(),
              limit,
              activeArea.height());
    painter->fillRect(bar, useColoredScale ? lowerColor : defaultColor);
    if (currentValue <= lowerThreshold)
        return;

    value = std::min(currentValue, upperThreshold);
    bar.setLeft(limit);
    bar.setRight(limit = activeArea.width() * value / maximumValue);
    painter->fillRect(bar, useColoredScale ? midColor : defaultColor);
    if (currentValue <= upperThreshold)
        return;

    bar.setLeft(limit);
    bar.setRight(activeArea.width() * currentValue / maximumValue);
    painter->fillRect(bar, useColoredScale ? upperColor : defaultColor);
}

void HorizontalVolumeBarWidget::drawTriggerIndicator (QPainter *painter, int triggerValue)
{
    int const x = activeArea.left() + activeArea.width() * triggerValue / maximumValue;
    painter->setPen(QPen(triggerIndicatorColor, 6));
    painter->drawLine(x, activeArea.top(), x, activeArea.bottom());
}

void HorizontalVolumeBarWidget::prepareBackground ()
{
    QPainter painter(background);
    initPainter(&painter);

#ifdef Q_WS_MAEMO_5
    painter.fillRect(0, 0, w, h, Qt::white);
#endif

    QFont f = painter.font();
#ifdef Q_WS_MAEMO_5
    int const fontSize = f.pointSize() * (h + 300) / 250;
#else
    int const fontSize = f.pointSize() * (h + 300) / 150;
#endif
    f.setPixelSize(fontSize);
    painter.setFont(f);

    int const markLenLong = h / 15;
    int const markLenShort = h / 24;

    QRect frame(10, 10, w - 20, h - 25 - markLenLong - fontSize);
    painter.setPen(thinPen);
    painter.drawRect(frame);

    activeArea.setRect(frame.left() + (thinPen.width() + 1) / 2,
                       frame.top() + (thinPen.width() + 1) / 2,
                       frame.width() - thinPen.width(),
                       frame.height() - thinPen.width());

    int const tag = maximumValue < 60 ? 10 : maximumValue < 150 ? 20 : 50;

    for (int i = 0; i < maximumValue; i += 10)
    {
        int x = frame.left() + frame.width() * i / maximumValue;
        int y = frame.bottom();
        int markLen;

        if (i % tag == 0)
        {
            if(i == 0)
                x += (thickPen.width() - thinPen.width() + 1) / 2;

            markLen = markLenLong;
            painter.setPen(thinPen);
            painter.drawText(x - 100, y + markLen + 10, 200, fontSize, Qt::AlignCenter, QString().setNum(i));
            painter.setPen(thickPen);
        }
        else
        {
            markLen = markLenShort;
            painter.setPen(thinPen);
        }

        int const compensation = (painter.pen().width() + 1) / 2;
        painter.drawLine(x, y + compensation, x, y + compensation + markLen);
    }
}
