/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of vumeter.
 *
 *  vumeter is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vumeter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with vumeter.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "volumemeterwidget.h"

#include <QPen>
#include <QRect>

VolumeMeterWidget::VolumeMeterWidget(QWidget *parent) :
    QWidget(parent)
{
    currentValue = 0;
}

void VolumeMeterWidget::paintEvent(QPaintEvent *event){
    QPainter painter(this);
    painter.setRenderHint(QPainter::Antialiasing, true);

    painter.setViewport(0, 0, width(), height());
    painter.setWindow(-150, -340, 300, 100);

    draw(& painter);
}

void VolumeMeterWidget::draw(QPainter *painter){
    QRectF background(-150, -340, 300, 100);
    painter->drawRect(background);
    painter->fillRect(background, QBrush(Qt::white));

    QPen thinPen(Qt::black);
    thinPen.setWidth(2);

    QPen thickPen(Qt::black);
    thickPen.setWidth(4);

    painter->drawText(-20, -270, 40, 20, Qt::AlignCenter, "dB");

    painter->rotate(-25);
    for(int i = 0; i < 23; i++){
        if(i % 4 == 0){
            if(i >= 16){
                thickPen.setColor(Qt::red);
            }

            painter->setPen(thickPen);
            painter->drawLine(0, -297, 0, -315);
            painter->drawText(-20, -340, 40, 20, Qt::AlignCenter, QString().setNum((i/4)*20));
        }else{
            if(i >= 16){
                thinPen.setColor(Qt::red);
            }
            painter->setPen(thinPen);

            if(i % 2 == 0){
                painter->drawLine(0, -296, 0, -308);
            }else{
                painter->drawLine(0, -296, 0, -303);
            }
        }

        painter->rotate(50./110.*5.);
    }
    painter->rotate(-50./110.*5.);

    painter->rotate(-25);
    thinPen.setColor(Qt::black);
    painter->setPen(thinPen);
    painter->drawArc(-160, -295, 320, 150, 35*16, 110*16);

    painter->rotate(-25);
    painter->rotate(50./110. * currentValue);
    thinPen.setColor(Qt::red);
    painter->setPen(thinPen);
    painter->drawLine(0, 0, 0, -325);
}

void VolumeMeterWidget::updateValue(int value){
    currentValue = value;
    emit update();
}
