#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QStringList>

#define MIN_DB -100

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    void updateVuMeter(const float *data);

signals:
    void updateVuMeterSignal(float);

private:
    Ui::MainWindow *ui;

    int maxVol;
    const QStringList *sources;

private slots:
    void resetMaxValue();
    void setDbScale();
    void setLinearScale();
    void sourceChanged(QString source);
    void updateValues(float value);
};

#endif // MAINWINDOW_H
