#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "pa_utils.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    maxVol = 0;

    ui->setupUi(this);

    context_create();
    const char *source;
    source = get_source_name();
    qDebug("Recording from: %s", source);
    connect_to_vu_meter_stream(source, this);

    connect(this, SIGNAL(updateVuMeterSignal(float)), this, SLOT(updateValues(float)), Qt::QueuedConnection);
    connect(ui->maxLabel, SIGNAL(linkActivated(QString)), this, SLOT(resetMaxValue()));

    ui->volumeBar->setValue(0);
    ui->currentVolume->setNum(0);
    ui->maximumVolume->setNum(0);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::resetMaxValue(){
    maxVol = 0;
    ui->maximumVolume->setNum(maxVol);
}

void MainWindow::updateValues(float value){
    int vol = 100 * value;

    ui->volumeBar->setValue(vol);
    ui->currentVolume->setNum(vol);
    if(maxVol < vol){
        maxVol = vol;
        ui->maximumVolume->setNum(vol);
    }
}

void MainWindow::updateVuMeter(const float *data){
    float vol = *data;

    if(vol >= 0 && vol < 1){
        emit updateVuMeterSignal(vol);
    }
}


