/* maemo vpnc-gui
 * 
 * Copyright (c) 2007-2008 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

/*
 * SUID wrapper for vpnc / openvpn
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "config.h"

pid_t pid=-1;

void interrupt(int sig) {
	if(pid!=-1) {
		fprintf(stderr, "Interrupt, terminating vpn client ...\n");
		kill(pid, SIGINT);
	}
}

int main(int argc, char *argv[]) {

	if(argc!=3)
		exit(1);

	fprintf(stderr, "Launching vpn client, please be patient ...\n");
	fprintf(stderr, "\n");


	signal(SIGINT, interrupt);
	signal(SIGTERM, interrupt);


        /* damn important: ignore SIGPIPE,
         * if we don't one of these printfs may cause a SIGPIPE and
         * kill the program (before killing our child)
         */
        signal(SIGPIPE, SIG_IGN);

	
	pid=fork();
	if(pid==-1) {
		perror("fork");
		exit(1);
	}

	if(pid==0) {

		if(setreuid (geteuid(), geteuid()) == -1) {
			perror("setreuid");
			exit(1);
		}
		if(setregid(getegid(), getegid()) == -1) {
			perror("setregid");
			exit(1);
		}


		/* /sbin/ in PATH needed for network-config scripts */
		if(setenv("PATH", "/sbin:/usr/sbin/:/bin/:/usr/bin", 1)==-1) {
			perror("setenv");
			exit(1);
		}

		if(setenv("LD_PRELOAD", SHAREDLIBDIR"/libgetpass.so", 1)==-1) {
			perror("setenv");
			exit(1);
		}


		if(strcmp(argv[1], "vpnc")==0) {
			execl("/usr/sbin/vpnc", "vpnc", "--non-inter", "--no-detach", argv[2], NULL);
		}
		else if(strcmp(argv[1], "openvpn")==0) {
			execl("/usr/sbin/openvpn", "openvpn", "--config", argv[2], NULL);

		}

		perror("execl");
		exit(1);
	}
	else {

		/* monitor child */
		int status;
		waitpid(pid, &status, 0);

		fprintf(stderr, "Child exited ...\n");

	}

	exit(0);

}
