/* maemo vpnc-gui
 * 
 * Copyright (c) 2007-2008 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

/* IMPORTS */
#include <gtk/gtk.h>
#include <stdio.h>
#include <sys/stat.h>
#include <pwd.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <dirent.h>
#include <glib.h>
#include <sys/wait.h>

#ifndef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE
#endif
// TODO: shit!
int kill(pid_t pid, int sig);
#include <sys/types.h>
#include <signal.h>

#include "profile.h"
#include "profiles_launcher.h"
#include "profiles_launcher_vpnc.h"
#include "profiles_backend.h"


#define GTK_ENABLE_BROKEN
#include <gtk/gtktext.h>

#define VPNC_WRAPPER_CONNECT    "/usr/bin/vpnc-gui-connect"

/* (local) VARIABLES */

/** current profile */
static struct profile *curr_profile;

/** gdk input tag for async IO */
static gint stdout_tag=-1;
static gint stderr_tag=-1;

static gint stdin_fd=-1;
static gint stdout_fd=-1;
static gint stderr_fd=-1;

static GPid vpnc_pid=-1; 
  
/** callback function to call in case of events */
static void (*event_cb)(struct profile *, gint event, gpointer data)=NULL;


/* LOCAL FUNCTIONS */

/**
 * Create an event with current profile as profile.
 * @param event the event
 * @param data pointer to  more data
 */
static void create_event(gint event, gpointer data) {
	if(event_cb!=NULL)
		event_cb(curr_profile, event, data);
}

/**
 * watch child process and receive events
 */
static void child_state_cb(GPid pid, gint status, gpointer data) {

  puts("child state");

  if(WIFEXITED(status)) {
  }

  puts("vpnc exited");
  create_event(PROFILES_LAUNCHER_EVENT_DISCONNECTED, NULL);

  /* set pid to -1 */
  vpnc_pid=-1;

  /* Reap child if needed. */
  waitpid (pid, NULL, WNOHANG);

}
	
static void child_input_cb(gpointer data, int fd, GdkInputCondition cond) {

  ssize_t bytes;
  char buf[1024];
  int errnosave=0;
 
  if(cond != GDK_INPUT_READ) {
    puts("fixme");
    return;
  }

  while( (bytes=read(fd, buf, sizeof(buf)-1)) > 0) {
    buf[bytes]='\0';
    //printf("Read: %s\n", buf);
    

    /* parse output, line by line */
    gchar *ptr=buf;
    gchar *token;
    while( (token=strtok(ptr, "\n")) != NULL) {
	    printf("line: %s\n", token);
	    create_event(PROFILES_LAUNCHER_EVENT_STDOUT, token);
	    ptr=NULL;

	    if(strcmp(token, "vpnc: authentication unsuccessful")==0) {
		    create_event(PROFILES_LAUNCHER_EVENT_AUTHENTICATION_FAILED, NULL);
	    }
	    if(strcmp(token, "vpnc: can't initialise tunnel interface")==0) {
		    create_event(PROFILES_LAUNCHER_EVENT_TUNDEV_FAILED, NULL);
	    }
	    if(strcmp(token, "vpnc: no response from target")==0) {
		    create_event(PROFILES_LAUNCHER_EVENT_TARGET_NOT_RESPONDING, NULL);
	    }
	    if(strncmp(token, "vpnc: unknown host", strlen("vpnc: unknown host"))==0) {
		    create_event(PROFILES_LAUNCHER_EVENT_UNKNOWN_HOST, NULL);
	    }
	    if(strncmp(token, "VPNC started in foreground", strlen("VPNC started in foreground"))==0) {
		    create_event(PROFILES_LAUNCHER_EVENT_CONNECTED, NULL);
	    }
	    if(strncmp(token, "vpnc: missing Xauth password", strlen("vpnc: missing Xauth password"))==0) {
	    }
	    if(strncmp(token, "Password for VPN", strlen("Password for VPN"))==0) {
	      create_event(PROFILES_LAUNCHER_EVENT_PASSWORD_CHALLENGE, NULL);
	    }

	    if(strncmp(token, "Passcode for VPN", strlen("Passcode for VPN"))==0) {
	      create_event(PROFILES_LAUNCHER_EVENT_PASSWORD_CHALLENGE, NULL);
	    }
	    if(strncmp(token, "Answer for VPN", strlen("Answer for VPN"))==0) {
	      create_event(PROFILES_LAUNCHER_EVENT_PASSWORD_CHALLENGE, NULL);
	    }


    }

  }

  /* save errno from read */
  errnosave=errno;

#ifdef DEBUG
  perror("read");
#endif

  if(errnosave != EAGAIN && errnosave != 0) {
    /* we probably hit EOF */
#ifdef DEBUG
    puts("removing io");
#endif
    puts("removing io");

    // TODO: fixme, make sure process is dead! kill it otherwise, but dont
    // issue an vpnc_disconnect(NULL) !!!!

    
    gdk_input_remove(stdout_tag);
    gdk_input_remove(stderr_tag);
    stdout_tag=-1;
    stderr_tag=-1;
  }

}


/* EXPORTS */

/**
 * Initialize module. Must be called before any other functions.
 */
void profiles_launcher_vpnc_init() {
}

/**
 * Connect to specified vpnc profile.
 * @param p the profile
 */
void profiles_launcher_vpnc_connect(struct profile *p) {

	curr_profile=p;
	gchar *config_path=profiles_backend_profile_to_filename(p);

#ifdef DEBUG
  printf("Starting vpnc (conf=%s)...\n", config_path);
#endif

  create_event(PROFILES_LAUNCHER_EVENT_CONNECTING, NULL);
  
  GPtrArray *vpnc_argv = g_ptr_array_new ();
  g_ptr_array_add (vpnc_argv, VPNC_WRAPPER_CONNECT);
  g_ptr_array_add (vpnc_argv, "vpnc");
  g_ptr_array_add (vpnc_argv, config_path);
  g_ptr_array_add (vpnc_argv, NULL);

  GError *error=NULL;
  GPid pid;
  GSource *vpnc_watch;

  if (!g_spawn_async_with_pipes (NULL, /* CWD */
			  (char **) vpnc_argv->pdata, /* argv */
			  NULL, /* envp */
			  G_SPAWN_DO_NOT_REAP_CHILD, /* flags */
			  NULL, /* child setup */
			  NULL, /* user data */
			  &pid,
			  &stdin_fd,
			  &stdout_fd,
			  &stderr_fd,
			  &error))
  {
	  g_ptr_array_free(vpnc_argv, TRUE);
	  printf("vpnc failed to start.  error: '%s'", error->message);
	  g_error_free(error);
	  return;
  }
  g_ptr_array_free (vpnc_argv, TRUE);

  printf("pid: %d\n", pid);
  vpnc_pid=pid;

  vpnc_watch=g_child_watch_source_new(pid);
  g_source_set_callback (vpnc_watch, (GSourceFunc) child_state_cb, NULL, NULL);

  g_source_attach(vpnc_watch, NULL);
  g_source_unref(vpnc_watch);

  /* remove old tag */
  if(stdout_tag > -1)
	  gtk_input_remove(stdout_tag);
  if(stderr_tag > -1)
	  gtk_input_remove(stderr_tag);


  /* make nonblocking */
  if(fcntl(stdout_fd, F_SETFL, O_NONBLOCK) == -1) {
    perror("fcntl failed");
  }
  if(fcntl(stderr_fd, F_SETFL, O_NONBLOCK) == -1) {
    perror("fcntl failed");
  }

  /* use gdk to monitor read end of stdout */
  stdout_tag=
	  gdk_input_add(stdout_fd,
			  GDK_INPUT_READ,
			  child_input_cb,
			  NULL); 
  stderr_tag=
	  gdk_input_add(stderr_fd,
			  GDK_INPUT_READ,
			  child_input_cb,
			  NULL); 

}

/**
 * Disconnect specified vpnc profile.
 * @param p the profile
 */
void profiles_launcher_vpnc_disconnect(struct profile *p) {

#ifdef DEBUG
  printf("Stopping vpnc ...\n");
#endif

  create_event(PROFILES_LAUNCHER_EVENT_DISCONNECTING, NULL);

  /*
  gchar *cmd=g_strdup_printf(VPNC_WRAPPER_DISCONNECT " %d", vpnc_pid);
  puts(cmd);
  g_spawn_command_line_async(cmd, NULL);
  g_free(cmd);
  */

  if(vpnc_pid > 0) {
	  /* accidently doing kill(-1, SIGTERM) is not
	   * a good idea ;-)
	   */

	  puts("terminating process ....");
	  kill(vpnc_pid, SIGTERM);
  }

}

/**
 * Set the callback function for connection events,
 * @param callback the function-pointer
 */
void profiles_launcher_vpnc_set_event_callback(void (*callback)(struct profile *, gint event, gpointer data)) {
	event_cb=callback;
}

/**
 * Feed password to vpnc
 * @param p pointer to the profile
 * @param pw pointer to the password, no reference is kept
 */
void profiles_launcher_vpnc_feed_password(struct profile *p, const gchar *pw) {
  write(stdin_fd, pw, strlen(pw));
  write(stdin_fd, "\n", 1);
}
