/* maemo vpnc-gui
 * 
 * Copyright (c) 2007-2008 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

#ifndef __CONFIG_DATA_OPENVPN_H__
#define __CONFIG_DATA_OPENVPN_H__

#define OPENVPN_TCP 1
#define OPENVPN_UDP 2

/** struct that describes configuration data for openvpn */
typedef struct {

	/** device: tunX or tapX */
	char *dev;
	/** protocol, OPENVPN_TCP or OPENVPN_UDP */
	int proto;
	/** remote hostname */
	char *remote_host;
	/** remote port */
	int remote_port;
	/** local port */
	int local_port;
	/** enable lzo (0|1) */
	int lzo;
	/** ping */
	int ping;
	/** ping restart */
	int ping_restart;
	
	
	/*
	 * resolv-retry
	 * user nobody
	 * user nogroup
	 * persist-key
	 * persist-tun
	 * ca crt
	 * cert crt
	 * key key
	 * ns-vert-type server
	 * tls-auth xyz 1
	 * cipher x
	 * ping-timer-rem
	 * ...
	 */

	

} config_data_openvpn;

config_data_openvpn *config_data_openvpn_alloc();
void config_data_openvpn_free(config_data_openvpn *c);

#endif
