/* maemo vpnc-gui
 * 
 * Copyright (c) 2007-2008 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

/* IMPORTS */
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/types.h>
#include <regex.h>
#include <strings.h>
#include <glib.h>
#include "config_data_vpnc.h"
#include "cisco-decrypt.h"

/* TODO: close/munmap */


/* EXPORTS */

/**
 * Open specified PCF-File, parse data and save values to specified 
 * config_data_vpnc struct
 * @param filename path to PCF-File
 * @param data pointer to a config_data_vpnc struct
 */
void pcf_import_file(char *filename,
		     config_data_vpnc *data) {

  int fd=open(filename, O_RDONLY);
  if(fd==-1) {
    perror("open failed");
    return;
  }

  struct stat stat_buf;

  if(fstat(fd, &stat_buf)==-1) {
    perror("fstat failed");
    return;
  }

  void *start=mmap(0,
		   stat_buf.st_size,
		   PROT_READ,
		   MAP_SHARED,
		   fd,
		   0);

  if(start == MAP_FAILED) {
    /* note: mmap also fails if filesize = 0 */
    perror("mmap failed");
    return;
  }


  /* regex setup */
  regex_t linematch;
  regcomp(&linematch, "^(!?)(\\w*)\\s*=\\s*(\\S*)$", REG_EXTENDED);
  regmatch_t matches[4]; /* yes, 4 - first match is "everything" */

  char matchbuf[356];
  char key[100], value[256];

  char *current=start;
  char *next;
  while((void *)current < start+stat_buf.st_size) {

    next=index(current, '\n');
    if(next==NULL)
      break;

    if(next-current > sizeof(matchbuf)-1) {
      puts("scared of buffer overflows ...");
      return;
    }
    strncpy(matchbuf, current, next-current);
    matchbuf[next-current]='\0';

    /* strip \r */
    if((next-current-1) >= 0 && matchbuf[next-current-1]=='\r') {
      matchbuf[next-current-1]='\0';
    }

    /* next one */
    current=next+1;

    //printf("'%s'\n", matchbuf);

    
    if(regexec(&linematch, matchbuf, 4, matches, 0)==0) {
      /* match */

      if(matches[2].rm_eo - matches[2].rm_so > sizeof(key)-1) {
	puts("scared of buffer overflows ...");
	regfree(&linematch);
	return;
      }
      if(matches[3].rm_eo - matches[3].rm_so > sizeof(value)-1) {
	puts("scared of buffer overflows ...");
	regfree(&linematch);
	return;
      }
      
      
      if( (matches[2].rm_so != -1) && (matches[3].rm_so != -1)) {

	strncpy(key, matchbuf+matches[2].rm_so,
		matches[2].rm_eo - matches[2].rm_so);
	key[matches[2].rm_eo - matches[2].rm_so]='\0';
	
	strncpy(value, matchbuf+matches[3].rm_so,
		matches[3].rm_eo - matches[3].rm_so);
	value[matches[3].rm_eo - matches[3].rm_so]='\0';

	char read_only=0;
	
	/* if key is prefixed by a '!' property is marked read-only,
	 * see http://www.cisco.com/en/US/docs/security/vpn_client/cisco_vpn_client/vpn_client46/administration/guide/vcAch2.html
	 */
	if(matches[1].rm_so != -1) {
	  if(*(matchbuf+matches[1].rm_so)=='!')
	    read_only=1;
	}

	printf("key: '%s', value: '%s' %s\n",
	       key, value,
	       read_only ? "(read only)" : "");
	
	if(strcmp(key, "Host")==0) {
	  if(data->ipsec_gw)
	    g_free(data->ipsec_gw);
	  data->ipsec_gw=g_strdup(value);
	}
	else if(strcmp(key, "GroupName")==0) {
	  if(data->ipsec_id)
	    g_free(data->ipsec_id);
	  data->ipsec_id=g_strdup(value);
	}
	else if(strcmp(key, "GroupPwd")==0) {
	  if(data->ipsec_secret)
	    g_free(data->ipsec_secret);
	  data->ipsec_secret=g_strdup(value);
	}
	else if(strcmp(key, "UserPassword")==0) {
	  if(data->xauth_pw)
	    g_free(data->xauth_pw);
	  data->xauth_pw=g_strdup(value);
	}
	else if(strcmp(key, "enc_GroupPwd")==0 && strlen(value)>0) {
	  char *dec=decode_cisco_string(value);
	  if(dec!=NULL) {
	    if(data->ipsec_secret)
	      g_free(data->ipsec_secret);

	    data->ipsec_secret=g_strdup(dec);
	    free(dec);
	  }
	}
	else if(strcmp(key, "enc_UserPassword")==0 && strlen(value)>0) {
	  char *dec=decode_cisco_string(value);
	  if(dec!=NULL) {
	    if(data->xauth_pw)
	      g_free(data->xauth_pw);

	    data->xauth_pw=g_strdup(dec);
	    free(dec);
	  }
	}
	else if(strcmp(key, "Username")==0) {
	  if(data->xauth_user)
	    g_free(data->xauth_user);
	  data->xauth_user=g_strdup(value);
	}
	else if(strcmp(key, "NTDomain")==0) {
	  if(data->domain)
	    g_free(data->domain);
	  data->domain=g_strdup(value);
	}

      }
    }
  }
  regfree(&linematch);
}
