/* maemo vpnc-gui
 * 
 * Copyright (c) 2007 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

#ifndef __PROFILES_LAUNCHER_H__
#define __PROFILES_LAUNCHER_H__

/** something has been read from stdout of process */
#define PROFILES_LAUNCHER_EVENT_STDOUT 1
/** something has been read from stderr of process */
#define PROFILES_LAUNCHER_EVENT_STDERR 2

#define PROFILES_LAUNCHER_EVENT_CONNECTING 3
#define PROFILES_LAUNCHER_EVENT_CONNECTING_ERROR 4
#define PROFILES_LAUNCHER_EVENT_CONNECTED 5

#define PROFILES_LAUNCHER_EVENT_DISCONNECTING 6 
#define PROFILES_LAUNCHER_EVENT_DISCONNECTING_ERROR 7
#define PROFILES_LAUNCHER_EVENT_DISCONNECTED 8

#define PROFILES_LAUNCHER_EVENT_PASSWORD_CHALLENGE 9

#define PROFILES_LAUNCHER_EVENT_AUTHENTICATION_FAILED 10
#define PROFILES_LAUNCHER_EVENT_TUNDEV_FAILED 11
#define PROFILES_LAUNCHER_EVENT_TARGET_NOT_RESPONDING 12
#define PROFILES_LAUNCHER_EVENT_UNKNOWN_HOST 13

void profiles_launcher_init();
void profiles_launcher_connect(struct profile *p);
void profiles_launcher_disconnect(struct profile *p);
void profiles_launcher_set_event_callback(void (*callback)(struct profile *, gint event, gpointer data));
void profiles_launcher_feed_password(struct profile *p, gchar *pw);
#endif
