/* maemo vpnc-gui
 * 
 * Copyright (c) 2007 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

#ifndef __PROFILES_BACKEND_H__
#define __PROFILES_BACKEND_H__

#include "profile.h"

void profiles_backend_init();
GList *profiles_backend_list_profiles();
gboolean profiles_backend_profile_name_exists(const gchar *name);
gchar *profiles_backend_profile_name_invalid(const gchar *name);
gboolean profiles_backend_delete_profile_by_name(char *name);
gboolean profiles_backend_save_profile(struct profile *p);
gchar *profiles_backend_profile_to_filename(struct profile *p);
gboolean profiles_backend_rename_profile(struct profile *p, const gchar *new_name);
#endif
