/*
 * This file is part of vncviewer
 *
 * Copyright (C) 2005-2007 Aaron Levinson, Detlef Schmicker.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __VNC_VIEWER__
#define __VNC_VIEWER__

#include "rfb.h"
#include <gtk/gtkwidget.h>
#include <gtk/gtkadjustment.h>
#include <gtk/gtkimmulticontext.h>

#define VNC_VIEWER(obj)      GTK_CHECK_CAST(obj, vnc_viewer_get_type(), VncViewer)
#define VNC_VIERWER_CLASS(k) GTK_CHECK_CLASS_CAST(obj, vnc_viewer_get_type(), VncViewerClass)
#define VNC_IS_VIEWER(obj)   GTK_CHECK_TYPE(obj, vnc_viewer_get_type())

typedef struct _VncViewer VncViewer;
typedef struct _VncViewerClass VncViewerClass;

typedef enum {
  VNC_VIEWER_DEPTH_DEFAULT = -1,
  VNC_VIEWER_DEPTH_8BIT    = 8,
  VNC_VIEWER_DEPTH_16BIT   = 16,
  VNC_VIEWER_DEPTH_24BIT   = 24
} VncViewerDepthType;

typedef enum {
  VNC_VIEWER_CURSOR_NORMAL,
  VNC_VIEWER_CURSOR_DOT,
  VNC_VIEWER_CURSOR_NONE
} VncViewerCursorType;

typedef enum {
  VNC_VIEWER_ROTATE_AUTO,
  VNC_VIEWER_ROTATE_ALWAYS,
  VNC_VIEWER_ROTATE_NEVER
} VncViewerRotationType;

typedef enum {
  VNC_VIEWER_ENCODING_AUTO,
  VNC_VIEWER_ENCODING_RAW,
  VNC_VIEWER_ENCODING_HEXTILE
} VncViewerEncodingType;

struct _VncViewer {
  GtkWidget parent;

  VncViewerCursorType cursor_type;

  gint fd; // the file descriptor for the RFB connection
  
  // these tags are from gdk_input_add when we are waiting on the fd
  guint in_tag, out_tag;

  // list of queued server bound messages
  GList *out_queue;

  guint16 width, height;
  rfbPixelFormat pixel_format;
  gchar *desk_name;

  guint8 button_mask;
  guint16 last_pointer_x_loc;
  guint16 last_pointer_y_loc;

  GdkPixmap *offscreen;
  GdkGC *gc;

  GdkCursor *none, *dot;

  GtkIMContext *im_context;

  gboolean m_bGotFirstUpdate;

  GTimeVal m_lockdownKeyPressTime;
  GTimeVal m_lockdownLastKeyPressTime;
  guint m_lockdownKeyPressKeyVal;

  void *mainview;
  gboolean m_bRotateDisplay;
};

struct _VncViewerClass {
  GtkWidgetClass parent_class;

  // handle the various server messages
  void (* vnc_framebuffer_update)     (VncViewer *vnc,
				       rfbServerToClientMsg *msg);
  void (* vnc_set_colourmap_entries)  (VncViewer *vnc,
				       rfbServerToClientMsg *msg,
				       guint16 *entries);
  void (* vnc_bell)                   (VncViewer *vnc,
				       rfbServerToClientMsg *msg);
  void (* vnc_server_cut_text)        (VncViewer *vnc,
				       rfbServerToClientMsg *msg,
				       gchar *text);
  void (* connection_died)            (VncViewer *vnc);
};

GtkType vnc_viewer_get_type(void);

GtkWidget *vnc_viewer_new(gint fd, gboolean shared, VncViewerDepthType depth,
			  VncViewerEncodingType encodingType);
void vnc_viewer_configure(VncViewer *vnc, gint fd, gboolean shared,
			  VncViewerDepthType depth,
			  VncViewerEncodingType encodingType);
void vnc_viewer_close_connection(VncViewer *vnc);
void vnc_viewer_set_cursor(VncViewer *vnc, VncViewerCursorType cursor_type);

void vnc_viewer_im_commit(GtkIMContext *im_context, gchar *text, gpointer data);
//void vnc_viewer_im_preedit_changed(GtkIMContext *im_context, gpointer data);

gint vnc_viewer_key_press_event(GtkWidget *widget,
				GdkEventKey *event);
gint vnc_viewer_key_release_event(GtkWidget *widget,
				  GdkEventKey *event);

void vnc_viewer_key_press(VncViewer *vnc, guint keyval);
void vnc_viewer_key_release(VncViewer *vnc, guint keyval);

#endif

