/*   VLC-REMOTE for MAEMO 5
*   Copyright (C) 2010 Schutz Sacha <istdasklar@gmail.com>, Dru Moore <usr@dru-id.co.uk>, Yann Nave <yannux@onbebop.net>
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 2,
*   or (at your option) any later version, as published by the Free
*   Software Foundation
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#include <QStringList>
#include <QNetworkInterface>
#include "appsettings.h"

bool AppSettings::_haveCurrentKey            = false;
QString AppSettings::_currentKey             = "";
bool AppSettings::_haveCurrentIp             = false;
QString AppSettings::_currentIp              = "";
bool AppSettings::_haveConnectionTimeout     = false;
int  AppSettings::_connectionTimeout         = 0;
bool AppSettings::_havePingTimeout           = false;
int  AppSettings::_pingTimeout               = 0;
bool AppSettings::_haveStatusPollTimeout     = false;
int  AppSettings::_statusPollTimeout         = 0;
bool AppSettings::_haveRetrieveArtTimeout    = false;
int  AppSettings::_retrieveArtTimeout        = 0;
bool AppSettings::_haveRetryNetworkTimeout   = false;
int  AppSettings::_retryNetworkTimeout       = 0;
bool AppSettings::_haveShowUnknownFileTypes  = false;
bool AppSettings::_showUnknownFileTypes      = false;
bool AppSettings::_haveShowAlbumArt          = false;
bool AppSettings::_showAlbumArt              = false;
bool AppSettings::_haveAlertOnClose          = false;
bool AppSettings::_alertOnClose              = false;
bool AppSettings::_haveOrientation           = false;
Orientation AppSettings::_orientation        = LANDSCAPE;

AppSettings::AppSettings() {
}

AppSettings::~AppSettings() {
    ;
}
bool AppSettings::isConnected() {
    QNetworkInterface wlan = QNetworkInterface::interfaceFromName("wlan0");
    QNetworkInterface gprs = QNetworkInterface::interfaceFromName("gprs0");
    return ( (wlan.isValid() && wlan.flags().testFlag(QNetworkInterface::IsUp)) || (gprs.isValid() && gprs.flags().testFlag(QNetworkInterface::IsUp)) );
}
QStringList AppSettings::getAllAccounts() {
    QStringList accounts;
    QSettings sets;
    sets.beginGroup("account");
    accounts = sets.allKeys();
    sets.endGroup();
    return accounts;
}
QString AppSettings::getCurrentKey() {
    if (!_haveCurrentKey) {
        QSettings sets;
        _currentKey = sets.value("config/currentKey", "").toString();
        _haveCurrentKey = true;
    }
    return _currentKey;
}
QString AppSettings::setCurrentKey(QString currentKey) {
    QSettings sets;
    sets.setValue("config/currentKey", currentKey);
    _currentKey = currentKey;
    _haveCurrentKey = true;
    return _currentKey;
}
QString AppSettings::getCurrentIp() {
    if (!_haveCurrentIp) {
        QSettings sets;
        _currentIp = sets.value("account/" + getCurrentKey(), "").toString();
        _haveCurrentIp = true;
    }
    return _currentIp;
}
QString AppSettings::setCurrentIp(QString currentIp) {
    QSettings sets;
    sets.setValue("account/" + getCurrentKey(), currentIp);
    _currentIp = currentIp;
    _haveCurrentIp = true;
    return _currentIp;
}
VlcDirectory AppSettings::getHomeDirectory() {
    QSettings sets;
    VlcDirectory home;
    home.name = sets.value("config/accounts/" + getCurrentKey() + "/homeDirName", "Default").toString();
    home.path = sets.value("config/accounts/" + getCurrentKey() + "/homeDirPath", "~/").toString();
    return home;
}
bool AppSettings::setHomeDirectory(VlcDirectory dir) {
    QSettings sets;
    sets.setValue("config/accounts/" + getCurrentKey() + "/homeDirName", dir.name);
    sets.setValue("config/accounts/" + getCurrentKey() + "/homeDirPath", dir.path);
    return true;
}
QList<VlcDirectory>* AppSettings::getFavourites() {
    QSettings sets;
    QList<VlcDirectory> * favourites = new QList<VlcDirectory>();

    sets.beginGroup("config/accounts/" + getCurrentKey() + "/favourites");
    foreach ( QString key, sets.allKeys())
    {
        VlcDirectory dir;
        // key is name
        dir.name = key;
        // value is path
        dir.path = sets.value(key, "~/").toString();
        favourites->append(dir);
    }
    sets.endGroup();
    return favourites;
}
bool AppSettings::addFavourite(VlcDirectory dir) {
    QSettings sets;
    // should check for existing first otherwise it overwrites
    if (0 < sets.value("config/accounts/" + getCurrentKey() + "/favourites/" + dir.name, "").toString().length()) {
        dir.name = "_" + dir.name;
        return addFavourite(dir); // recurse
    }
    sets.setValue("config/accounts/" + getCurrentKey() + "/favourites/" + dir.name, dir.path);
    return true;
}
bool AppSettings::deleteFavourite(VlcDirectory dir) {
    QSettings sets;
    sets.remove("config/accounts/" + getCurrentKey() + "/favourites/" + dir.name);
    return true;
}
int AppSettings::getStatusPollTimeout() {
    if (!_haveStatusPollTimeout) {
        QSettings sets;
        _statusPollTimeout = sets.value("config/statusPollTimeout", STATUS_POLL_TIMEOUT).toInt();
        _haveStatusPollTimeout = true;
    }
    return _statusPollTimeout;
}
int AppSettings::setStatusPollTimeout(int statusPollTimeout) {
    QSettings sets;
    sets.setValue("config/statusPollTimeout", statusPollTimeout);
    _statusPollTimeout = statusPollTimeout;
    _haveStatusPollTimeout = true;
    return _statusPollTimeout;
}
int AppSettings::getPingTimeout() {
    if (!_havePingTimeout) {
        QSettings sets;
        _pingTimeout = sets.value("config/pingTimeout", PING_TIMEOUT).toInt();
        _havePingTimeout = true;
    }
    return _pingTimeout;
}
int AppSettings::setPingTimeout(int pingTimeout) {
    QSettings sets;
    sets.setValue("config/pingTimeout", pingTimeout);
    _pingTimeout = pingTimeout;
    _havePingTimeout = true;
    return _pingTimeout;
}
int AppSettings::getConnectionTimeout() {
    if (!_haveConnectionTimeout) {
        QSettings sets;
        _connectionTimeout = sets.value("config/connectionTimeout", CONNECTION_TIMEOUT).toInt();
        _haveConnectionTimeout = true;
    }
    return _connectionTimeout;
}
int AppSettings::setConnectionTimeout(int connectionTimeout) {
    QSettings sets;
    sets.setValue("config/connectionTimeout", connectionTimeout);
    _connectionTimeout = connectionTimeout;
    _haveConnectionTimeout = true;
    return _connectionTimeout;
}
int AppSettings::getRetrieveArtTimeout() {
    if (!_haveRetrieveArtTimeout) {
        QSettings sets;
        _retrieveArtTimeout = sets.value("config/retrieveArtTimeout", RETRIEVE_ART_TIMEOUT).toInt();
        _haveRetrieveArtTimeout = true;
    }
    return _retrieveArtTimeout;
}
int AppSettings::setRetrieveArtTimeout(int retrieveArtTimeout) {
    QSettings sets;
    sets.setValue("config/retrieveArtTimeout", retrieveArtTimeout);
    _retrieveArtTimeout = retrieveArtTimeout;
    _haveRetrieveArtTimeout = true;
    return _retrieveArtTimeout;
}
int AppSettings::getRetryNetworkTimeout() {
    if (!_haveRetryNetworkTimeout) {
        QSettings sets;
        _retryNetworkTimeout = sets.value("config/retryNetworkTimeout", RETRY_NETWORK_TIMEOUT).toInt();
        _haveRetryNetworkTimeout = true;
    }
    return _retryNetworkTimeout;
}
int AppSettings::setRetryNetworkTimeout(int retryNetworkTimeout) {
    QSettings sets;
    sets.setValue("config/retryNetworkTimeout", retryNetworkTimeout);
    _retryNetworkTimeout = retryNetworkTimeout;
    _haveRetryNetworkTimeout = true;
    return _retryNetworkTimeout;
}
bool AppSettings::getShowUnknownFileTypes() {
    if (!_haveShowUnknownFileTypes) {
        QSettings sets;
        _showUnknownFileTypes = sets.value("config/showUnknownFileTypes", SHOW_UNKNOWN_FILETYPES).toBool();
        _haveShowUnknownFileTypes = true;
    }
    return _showUnknownFileTypes;
}
bool AppSettings::setShowUnknownFileTypes(bool showUnknownFileTypes) {
    QSettings sets;
    sets.setValue("config/showUnknownFileTypes", showUnknownFileTypes);
    _showUnknownFileTypes = showUnknownFileTypes;
    _haveShowUnknownFileTypes = true;
    return _showUnknownFileTypes;
}
bool AppSettings::getShowAlbumArt() {
    if (!_haveShowAlbumArt) {
        QSettings sets;
        _showAlbumArt = sets.value("config/showAlbumArt", SHOW_ALBUM_ART).toBool();
        _haveShowAlbumArt = true;
    }
    return _showAlbumArt;
}
bool AppSettings::setShowAlbumArt(bool showAlbumArt) {
    QSettings sets;
    sets.setValue("config/showAlbumArt", showAlbumArt);
    _showAlbumArt = showAlbumArt;
    _haveShowAlbumArt = true;
    return _showAlbumArt;
}
bool AppSettings::getAlertOnClose() {
    if (!_haveAlertOnClose) {
        QSettings sets;
        _alertOnClose = sets.value("config/alertOnClose", ALERT_ON_CLOSE).toBool();
        _haveAlertOnClose = true;
    }
    return _alertOnClose;
}
bool AppSettings::setAlertOnClose(bool alertOnClose) {
    QSettings sets;
    sets.setValue("config/alertOnClose", alertOnClose);
    _alertOnClose = alertOnClose;
    _haveAlertOnClose = true;
    return _alertOnClose;
}
Orientation AppSettings::getOrientation() {
    if (!_haveOrientation) {
        QSettings sets;
        return (Orientation)(sets.value("config/orientation", AUTO_ROTATE).toInt());
        _haveOrientation = true;
    }
    return _orientation;
}
Orientation AppSettings::setOrientation(Orientation orientation) {
    QSettings sets;
    sets.setValue("config/orientation", (int)orientation);
    _orientation = orientation;
    _haveOrientation = true;
    return _orientation;
}

