/*   VLC-REMOTE for MAEMO 5
*   Copyright (C) 2010 Schutz Sacha <istdasklar@gmail.com>, Dru Moore <usr@dru-id.co.uk>, Yann Nave <yannux@onbebop.net>
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 2,
*   or (at your option) any later version, as published by the Free
*   Software Foundation
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#include "favouritesmainwindow.h"
#include "ui_favouritesmainwindow.h"
#include <QSettings>
#if defined(Q_WS_S60) || defined(Q_WS_MAEMO_5)
#include <QMaemo5InformationBox>
#endif
#include "appsettings.h"
#include "browsemainwindow.h"

FavouritesMainWindow::FavouritesMainWindow(QWidget *parent) :
        QMainWindow(parent),
        ui(new Ui::FavouritesMainWindow)
{

    ui->setupUi(this);

    setWindowTitle("Vlc remote");
    mCurrentItemIndex = -1;

    ui->listWidget->setTextElideMode(Qt::ElideMiddle);
    ui->listWidget->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    ui->deleteButton->setIcon(QIcon::fromTheme("general_delete"));
    ui->editButton->setIcon(QIcon::fromTheme("general_sketch"));
    ui->browseButton->setIcon(QIcon::fromTheme("filemanager_media_folder"));
    ui->saveButton->setIcon(QIcon::fromTheme("notes_save"));
    ui->browseButton->setDisabled(true);
    ui->editButton->setDisabled(true);
    ui->deleteButton->setDisabled(true);
    ui->actionSetHome->setDisabled(true);
    ui->label->setVisible(false);
    ui->lineEdit->setVisible(false);
    ui->saveButton->setVisible(false);
    ui->saveButton->setDisabled(true);

    connect(ui->browseButton,SIGNAL(clicked()),this,SLOT(onBrowse()));
    connect(ui->deleteButton,SIGNAL(clicked()),this,SLOT(onDelete()));
    connect(ui->editButton,SIGNAL(clicked()),this,SLOT(onEdit()));
    connect(ui->listWidget, SIGNAL(itemSelectionChanged()), this, SLOT(onListSelectionChanged()));
    connect(ui->actionSetHome, SIGNAL(triggered()), this, SLOT(setHomeFolder()));
    connect(ui->saveButton, SIGNAL(clicked()), this, SLOT(onEditSave()));
    connect(ui->lineEdit, SIGNAL(textChanged(QString)), this, SLOT(onLineEditTextChanged(QString)));

    init();


}
void FavouritesMainWindow::init()  // THIS METHOD IS CALLED WHEN CONFIG CHANGED AND WINDOW SHOWN...
{
    mFavourites = AppSettings::getFavourites();
    updateList();
}

FavouritesMainWindow::~FavouritesMainWindow()
{
    delete mFavourites;
    delete ui;
}

void FavouritesMainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
void FavouritesMainWindow::updateList() {
    ui->listWidget->clear();
    if (NULL != mFavourites && 0 < mFavourites->count()) {
        for (int idx = 0; idx < mFavourites->count(); ++idx) {
            QListWidgetItem* item = new QListWidgetItem(QIcon::fromTheme("imageviewer_favourite"), mFavourites->at(idx).name, ui->listWidget, LIST_ITEM_TYPE_OFFSET + idx);
            ui->listWidget->addItem(item);
        }
    }
}
void FavouritesMainWindow::setHomeFolder() {
    if (-1 < mCurrentItemIndex) {
        AppSettings::setHomeDirectory(mCurrentFavourite);
    }
}
void FavouritesMainWindow::onListSelectionChanged() {
    ui->label->setVisible(false);
    ui->lineEdit->setVisible(false);
    ui->saveButton->setVisible(false);
    ui->saveButton->setDisabled(true);
    QList<QListWidgetItem *> items = ui->listWidget->selectedItems();
    if (0 < items.count()) {
        mCurrentItemIndex = ui->listWidget->currentIndex().row();
        mCurrentFavourite = mFavourites->at(items.at(0)->type() - LIST_ITEM_TYPE_OFFSET); // Qt reserves types up to 1000, we use an offset beyond that for index tracking. May prove to be too hacky!
        ui->browseButton->setDisabled(false);
        ui->editButton->setDisabled(false);
        ui->deleteButton->setDisabled(false);
        ui->actionSetHome->setDisabled(false);
    }
    else {
        mCurrentItemIndex = -1;
        ui->browseButton->setDisabled(true);
        ui->editButton->setDisabled(true);
        ui->deleteButton->setDisabled(true);
        ui->actionSetHome->setDisabled(true);
    }
}
void FavouritesMainWindow::onLineEditTextChanged(QString text) {
    if (0 < text.length()) {
        ui->saveButton->setDisabled(false);
    }
    else {
        ui->saveButton->setDisabled(true);
    }
}
void FavouritesMainWindow::onEditSave() {
    if (-1 < mCurrentItemIndex && 0 < ui->lineEdit->text().length()) {
        ui->label->setVisible(false);
        ui->lineEdit->setVisible(false);
        ui->saveButton->setVisible(false);
        ui->saveButton->setDisabled(true);
        AppSettings::deleteFavourite(mCurrentFavourite);
        mCurrentFavourite.name = ui->lineEdit->text();
        AppSettings::addFavourite(mCurrentFavourite);
        ui->lineEdit->setText("");
        ui->listWidget->itemAt(mCurrentItemIndex, 0)->setText(mCurrentFavourite.name);
        init();
    }
}
void FavouritesMainWindow::onEdit() {
    if (-1 < mCurrentItemIndex) {
        ui->label->setVisible(true);
        ui->lineEdit->setVisible(true);
        ui->saveButton->setVisible(true);
        ui->saveButton->setDisabled(false);
        ui->lineEdit->setText(mCurrentFavourite.name);
        ui->browseButton->setDisabled(true);
        ui->editButton->setDisabled(true);
        ui->deleteButton->setDisabled(true);
    }
}
void FavouritesMainWindow::onBrowse() {
    if (-1 < mCurrentItemIndex) {
        this->close();
        ((BrowseMainWindow *)this->parent())->browseDirectory(mCurrentFavourite.path);
    }
}
void FavouritesMainWindow::onDelete() {
    if (-1 < mCurrentItemIndex) {
        AppSettings::deleteFavourite(mCurrentFavourite);
        init();
    }
}
