/*   VLC-REMOTE for MAEMO 5
*   Copyright (C) 2010 Schutz Sacha <istdasklar@gmail.com>, Dru Moore <usr@dru-id.co.uk>, Yann Nave <yannux@onbebop.net>
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 2,
*   or (at your option) any later version, as published by the Free
*   Software Foundation
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#include "accountdialog.h"
#include "ui_accountdialog.h"
#include "newaccountdialog.h"
#include <QDebug>
#include <QInputDialog>
#include <QSettings>
#include <QTcpSocket>
#include <QFuture>
#include <QtConcurrentMap>



QListWidgetItem asyncTestItem(const QListWidgetItem &item)
{

    QListWidgetItem item2= item;
    item2.setText("boby");

    return item;

}




AccountDialog::AccountDialog(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::AccountDialog)
{
    ui->setupUi(this);

    mFuturWatcher = new QFutureWatcher<QListWidgetItem>(this);
    connect(mFuturWatcher,SIGNAL(resultReadyAt(int)),this,SLOT(setAsyncItem(int)));

    connect(ui->addButton,SIGNAL(clicked()),this,SLOT(add()));
    connect(ui->editButton,SIGNAL(clicked()),this,SLOT(edit()));
    connect(ui->remButton,SIGNAL(clicked()),this,SLOT(rem()));
    connect(ui->useButton,SIGNAL(clicked()),this,SLOT(use()));
    connect(ui->listWidget, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(enableUi()));

    load();

}

AccountDialog::~AccountDialog()
{
    delete ui;
}

void AccountDialog::add()
{

    NewAccountDialog *dialog = new NewAccountDialog(this);
    dialog->exec();
    load();
}
QString AccountDialog::currentIp()
{

    QSettings settings;
    QString useKey = settings.value("config/currentKey").toString();
    QString useIp ;
    if ( !useKey.isEmpty())
        useIp = settings.value("account/"+useKey).toString();

    else return QString();

    return useIp;
}

void AccountDialog::load()
{
    ui->editButton->setEnabled(false);
    ui->remButton->setEnabled(false);
    ui->useButton->setEnabled(false);
    ui->listWidget->clear(); // tjr effacer , sinon on rajoute

    QSettings settings;

    QString useKey = settings.value("config/currentKey").toString();

    QList <QListWidgetItem> asycItems;

    settings.beginGroup("account");
    foreach ( QString key, settings.allKeys())
    {
        QListWidgetItem * item = new QListWidgetItem;

        item->setText(key);
        item->setData(Qt::UserRole, settings.value(key));
        if (useKey == key) {
            QFont font = item->font();
            font.setBold(true);
            item->setFont(font);
        }
        ui->listWidget->addItem(item);
        asycItems.append(*item);
    }
    settings.endGroup();    


    // ... create and add in the list widget

    //  QFuture<QListWidgetItem> itemFutur = QtConcurrent::mapped(asycItems, asyncTestItem);


    mFuturWatcher->setFuture(QtConcurrent::mapped(asycItems, asyncTestItem));
}

QListWidgetItem AccountDialog::asyncTestItem(const QListWidgetItem& item)
{
    //==========> NEED TO USE POINTER TO AVOID setAsyncItem! But I don't know how;..
    QListWidgetItem newItem = item;

    QTcpSocket * socket = new QTcpSocket;
    QSettings settings;
    QString host = settings.value("account/"+item.text()).toString();

    if(host.contains(":"))
    {
        QStringList hostSplit = host.split(":");
        QString ip   = hostSplit.at(0);
        QString port = hostSplit.at(1);
        socket->connectToHost(ip,port.toInt());
    }

    else
        socket->connectToHost(host,8080);

    if (socket->waitForConnected(1000))
        newItem.setIcon(QIcon::fromTheme("widgets_tickmark_list"));
    else
        newItem.setIcon(QIcon::fromTheme("statusarea_presence_busy_error"));

    return newItem;


}



void AccountDialog::setAsyncItem(int row)  // EDIT THE ROW AFTER ASYNC FUNCTION FINISHED
{
    QListWidgetItem newItem = mFuturWatcher->resultAt(row);
    QListWidgetItem * item = ui->listWidget->item(row);

    item->setIcon(newItem.icon());



}



void AccountDialog::edit()
{
    QString currentIp = ui->listWidget->currentItem()->data(Qt::UserRole).toString();
    QString currentKey = ui->listWidget->currentItem()->text();

    NewAccountDialog *dialog = new NewAccountDialog(this);
    dialog->edit(currentKey, currentIp);
    dialog->exec();

    load();
}

void AccountDialog::rem()
{
    QString key = ui->listWidget->currentItem()->text();

    QSettings settings;
    settings.beginGroup("account");
    settings.remove(key);
    settings.endGroup();

    load(); // On recharge les compte
}

void AccountDialog::use()
{
    QString currentKey = ui->listWidget->currentItem()->text();
    QSettings settings;
    settings.setValue("config/currentKey", currentKey);
    load();
    emit accept();
}

void AccountDialog::enableUi()
{
    ui->editButton->setEnabled(true);
    ui->remButton->setEnabled(true);
    ui->useButton->setEnabled(true);
}
